/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.sword.ATOMCollectionGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Collection;

public class CollectionCollectionGenerator
extends ATOMCollectionGenerator {
    private static Logger log = Logger.getLogger(CollectionCollectionGenerator.class);

    public CollectionCollectionGenerator(SWORDService service) {
        super(service);
        log.debug((Object)"Create new instance of CollectionCollectionGenerator");
    }

    public Collection buildCollection(DSpaceObject dso) throws DSpaceSWORDException {
        if (!(dso instanceof org.dspace.content.Collection)) {
            log.error((Object)"buildCollection passed argument which is not of type Collection");
            throw new DSpaceSWORDException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        org.dspace.content.Collection col = (org.dspace.content.Collection)dso;
        Collection scol = new Collection();
        String location = urlManager.getDepositLocation(col);
        String title = col.getMetadata("name");
        String collectionPolicy = col.getLicense();
        String dcAbstract = col.getMetadata("short_description");
        boolean mediation = swordConfig.isMediated();
        scol.setLocation(location);
        if (title != null && !"".equals(title)) {
            scol.setTitle(title);
        }
        if (collectionPolicy != null && !"".equals(collectionPolicy)) {
            scol.setCollectionPolicy(collectionPolicy);
        }
        if (dcAbstract != null && !"".equals(dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(mediation);
        List accepts = this.swordService.getSwordConfig().getCollectionAccepts();
        for (String accept : accepts) {
            scol.addAccepts(accept);
        }
        Map aps = swordConfig.getAcceptPackaging(col);
        for (Map.Entry ap : aps.entrySet()) {
            scol.addAcceptPackaging((String)ap.getKey(), ((Float)ap.getValue()).floatValue());
        }
        boolean itemService = ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"expose-items");
        if (itemService) {
            String subService = urlManager.constructSubServiceUrl(col);
            scol.setService(subService);
        }
        log.debug((Object)"Created ATOM Collection for DSpace Collection");
        return scol;
    }
}

