/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDService;
import org.purl.sword.base.AtomDocumentRequest;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDErrorException;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.ServiceDocumentRequest;

public class SWORDAuthenticator {
    private static Logger log = Logger.getLogger(SWORDAuthenticator.class);
    protected AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public boolean authenticates(Context context, String un, String pw) {
        int auth = this.authenticationService.authenticate(context, un, pw, null, null);
        return auth == 1;
    }

    private Context constructContext(String ip) throws SWORDException {
        Context context = new Context();
        context.setExtraLogInfo("session_id=0:ip_addr=" + ip);
        return context;
    }

    public SWORDContext authenticate(ServiceDocumentRequest request) throws SWORDException, SWORDErrorException, SWORDAuthenticationException {
        SWORDContext sc;
        Context context = this.constructContext(request.getIPAddress());
        try {
            sc = this.authenticate(context, request);
        }
        catch (RuntimeException | SWORDAuthenticationException | SWORDErrorException | SWORDException e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        return sc;
    }

    public SWORDContext authenticate(AtomDocumentRequest request) throws SWORDException, SWORDErrorException, SWORDAuthenticationException {
        Context context = this.constructContext(request.getIPAddress());
        SWORDContext sc = null;
        try {
            sc = this.authenticate(context, request);
        }
        catch (RuntimeException | SWORDAuthenticationException | SWORDErrorException | SWORDException e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        return sc;
    }

    private SWORDContext authenticate(Context context, AtomDocumentRequest request) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        return this.authenticate(context, request.getUsername(), request.getPassword(), null, request.getIPAddress());
    }

    private SWORDContext authenticate(Context context, ServiceDocumentRequest request) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        return this.authenticate(context, request.getUsername(), request.getPassword(), request.getOnBehalfOf(), request.getIPAddress());
    }

    public SWORDContext authenticate(Deposit deposit) throws SWORDException, SWORDErrorException, SWORDAuthenticationException {
        Context context = this.constructContext(deposit.getIPAddress());
        SWORDContext sc = null;
        try {
            sc = this.authenticate(context, deposit);
        }
        catch (RuntimeException | SWORDAuthenticationException | SWORDErrorException | SWORDException e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        return sc;
    }

    private SWORDContext authenticate(Context context, Deposit deposit) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        return this.authenticate(context, deposit.getUsername(), deposit.getPassword(), deposit.getOnBehalfOf(), deposit.getIPAddress());
    }

    private SWORDContext authenticate(Context context, String un, String pw, String obo, String ip) throws SWORDAuthenticationException, SWORDException, SWORDErrorException {
        boolean mediated;
        if ("".equals(obo)) {
            obo = null;
        }
        if (!(mediated = ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"on-behalf-of.enable")) && obo != null) {
            log.error((Object)"Attempted mediated deposit on service not configured to do so");
            throw new SWORDErrorException("http://purl.org/net/sword/error/MediationNotAllowed", "Mediated deposit to this service is not permitted");
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"sword_authenticate", (String)("username=" + un + ",on_behalf_of=" + obo)));
        try {
            SWORDContext sc = new SWORDContext();
            EPerson ep = null;
            boolean authenticated = false;
            if (this.authenticates(context, un, pw)) {
                ep = context.getCurrentUser();
                if (ep != null) {
                    authenticated = true;
                    sc.setAuthenticated(ep);
                    List groups = this.authenticationService.getSpecialGroups(context, null);
                    for (Group group : groups) {
                        context.setSpecialGroup(group.getID());
                        log.debug((Object)("Adding Special Group id=" + group.getID()));
                    }
                    sc.setAuthenticatorContext(context);
                    sc.setContext(context);
                }
                EPerson epObo = null;
                if (obo != null) {
                    epObo = this.ePersonService.findByEmail(context, obo);
                    if (epObo == null) {
                        epObo = this.ePersonService.findByNetid(context, obo);
                    }
                    if (epObo != null) {
                        sc.setOnBehalfOf(epObo);
                        Context oboContext = this.constructContext(ip);
                        oboContext.setCurrentUser(epObo);
                        List groups = this.authenticationService.getSpecialGroups(oboContext, null);
                        for (Group group : groups) {
                            oboContext.setSpecialGroup(group.getID());
                            log.debug((Object)("Adding Special Group id=" + group.getID()));
                        }
                        sc.setContext(oboContext);
                    } else {
                        authenticated = false;
                        throw new SWORDErrorException("http://purl.org/net/sword/error/TargetOwnerUnknown", "unable to identify on-behalf-of user: " + obo);
                    }
                }
            }
            if (!authenticated) {
                if (ep != null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"sword_unable_to_set_user", (String)("username=" + un)));
                    throw new SWORDAuthenticationException("Unable to authenticate the supplied used");
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"sword_unable_to_set_on_behalf_of", (String)("username=" + un + ",on_behalf_of=" + obo)));
                throw new SWORDAuthenticationException("Unable to authenticate the onBehalfOf account");
            }
            return sc;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SWORDException("There was a problem accessing the repository user database", (Exception)e);
        }
    }

    public boolean canSubmit(SWORDService swordService, Deposit deposit, DSpaceObject dso) throws DSpaceSWORDException, SWORDErrorException {
        SWORDContext swordContext = swordService.getSwordContext();
        boolean submit = this.canSubmitTo(swordContext, dso);
        if (submit) {
            swordService.message("User is authorised to submit to collection");
        } else {
            swordService.message("User is not authorised to submit to collection");
        }
        return submit;
    }

    public boolean isUserAdmin(SWORDContext swordContext) throws DSpaceSWORDException {
        try {
            EPerson authenticated = swordContext.getAuthenticated();
            return authenticated != null && this.authorizeService.isAdmin(swordContext.getAuthenticatorContext());
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public boolean isOnBehalfOfAdmin(SWORDContext swordContext) throws DSpaceSWORDException {
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        try {
            return onBehalfOf != null && this.authorizeService.isAdmin(swordContext.getOnBehalfOfContext());
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public boolean isUserInGroup(SWORDContext swordContext, Group group) {
        EPerson authenticated = swordContext.getAuthenticated();
        return authenticated != null && this.isInGroup(group, authenticated);
    }

    public boolean isOnBehalfOfInGroup(SWORDContext swordContext, Group group) {
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        return onBehalfOf != null && this.isInGroup(group, onBehalfOf);
    }

    public boolean isInGroup(Group group, EPerson eperson) {
        List eps = group.getMembers();
        List groups = group.getMemberGroups();
        for (EPerson ep : eps) {
            if (!eperson.getID().equals(ep.getID())) continue;
            return true;
        }
        if (groups != null && !groups.isEmpty()) {
            for (Group group1 : groups) {
                if (!this.isInGroup(group1, eperson)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Community> getAllowedCommunities(SWORDContext swordContext) throws DSpaceSWORDException {
        try {
            Context context = swordContext.getContext();
            ArrayList<Community> allowed = new ArrayList<Community>();
            List comms = this.communityService.findAllTop(context);
            for (Community comm : comms) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)comm, 0);
                }
                if (!oboAllowed) {
                    oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)comm, 0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comm);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public List<Community> getCommunities(SWORDContext swordContext, Community community) throws DSpaceSWORDException {
        try {
            List comms = community.getSubcommunities();
            ArrayList<Community> allowed = new ArrayList<Community>();
            for (Community comm : comms) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)comm, 0);
                }
                if (!oboAllowed) {
                    oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)comm, 0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comm);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public List<Collection> getAllowedCollections(SWORDContext swordContext) throws DSpaceSWORDException {
        return this.getAllowedCollections(swordContext, null);
    }

    public List<Collection> getAllowedCollections(SWORDContext swordContext, Community community) throws DSpaceSWORDException {
        try {
            Context authContext = swordContext.getAuthenticatorContext();
            List cols = this.collectionService.findAuthorized(authContext, community, 3);
            ArrayList<Collection> allowed = new ArrayList<Collection>();
            for (Collection col : cols) {
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!oboAllowed) {
                    oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)col, 3);
                }
                if (!oboAllowed) continue;
                allowed.add(col);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public List<Item> getAllowedItems(SWORDContext swordContext, Collection collection) throws DSpaceSWORDException {
        try {
            ArrayList<Item> allowed = new ArrayList<Item>();
            Iterator ii = this.itemService.findByCollection(swordContext.getContext(), collection);
            while (ii.hasNext()) {
                boolean add;
                boolean write;
                Item item = (Item)ii.next();
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                List bundles = item.getBundles();
                if (!authAllowed) {
                    Bundle bundle;
                    write = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)item, 1);
                    add = false;
                    Iterator iterator = bundles.iterator();
                    while (iterator.hasNext() && (!"ORIGINAL".equals((bundle = (Bundle)iterator.next()).getName()) || (add = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)bundle, 3)))) {
                    }
                    boolean bl = authAllowed = write && add;
                }
                if (!oboAllowed) {
                    write = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)item, 1);
                    add = false;
                    for (Bundle bundle : bundles) {
                        if ("ORIGINAL".equals(bundle.getName())) {
                            add = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)bundle, 3);
                        }
                        if (add) continue;
                        break;
                    }
                    boolean bl = oboAllowed = write && add;
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(item);
            }
            return allowed;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public boolean canSubmitTo(SWORDContext swordContext, Collection collection) throws DSpaceSWORDException {
        try {
            boolean authAllowed = false;
            boolean oboAllowed = false;
            if (swordContext.getOnBehalfOf() == null) {
                oboAllowed = true;
            }
            if (!authAllowed) {
                authAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)collection, 3);
            }
            if (!oboAllowed) {
                oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)collection, 3);
            }
            return authAllowed && oboAllowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public boolean canSubmitTo(SWORDContext swordContext, Item item) throws DSpaceSWORDException {
        try {
            Bundle bundle;
            Iterator iterator;
            boolean add;
            boolean write;
            boolean authAllowed = false;
            boolean oboAllowed = false;
            if (swordContext.getOnBehalfOf() == null) {
                oboAllowed = true;
            }
            List bundles = item.getBundles();
            if (!authAllowed) {
                write = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)item, 1);
                add = false;
                iterator = bundles.iterator();
                while (iterator.hasNext() && (!"ORIGINAL".equals((bundle = (Bundle)iterator.next()).getName()) || (add = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)bundle, 3)))) {
                }
                boolean bl = authAllowed = write && add;
            }
            if (!oboAllowed) {
                write = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)item, 1);
                add = false;
                iterator = bundles.iterator();
                while (iterator.hasNext() && (!"ORIGINAL".equals((bundle = (Bundle)iterator.next()).getName()) || (add = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)bundle, 3)))) {
                }
                oboAllowed = write && add;
            }
            return authAllowed && oboAllowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public boolean canSubmitTo(SWORDContext context, DSpaceObject dso) throws DSpaceSWORDException {
        if (dso instanceof Collection) {
            return this.canSubmitTo(context, (Collection)dso);
        }
        return dso instanceof Item && this.canSubmitTo(context, (Item)dso);
    }
}

