/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class SimpleFileIngester
implements SWORDIngester {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepositResult ingest(SWORDService service, Deposit deposit, DSpaceObject target) throws DSpaceSWORDException, SWORDErrorException {
        try {
            Bitstream bs;
            if (!(target instanceof Item)) {
                throw new DSpaceSWORDException("SimpleFileIngester can only be loaded for deposit onto DSpace Items");
            }
            Item item = (Item)target;
            SWORDService swordService = service;
            Context context = swordService.getContext();
            SWORDUrlManager urlManager = swordService.getUrlManager();
            List bundles = item.getBundles();
            Bundle original = null;
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                original = bundle;
                break;
            }
            if (original == null) {
                original = this.bundleService.create(context, item, "ORIGINAL");
            }
            try (FileInputStream fis = null;){
                fis = new FileInputStream(deposit.getFile());
                bs = this.bitstreamService.create(context, original, (InputStream)fis);
            }
            String fn = swordService.getFilename(context, deposit, false);
            bs.setName(context, fn);
            swordService.message("File created in item with filename " + fn);
            BitstreamFormat bf = this.bitstreamFormatService.findByMIMEType(context, deposit.getContentType());
            if (bf != null) {
                bs.setFormat(context, bf);
            }
            context.turnOffAuthorisationSystem();
            this.bitstreamService.update(context, (DSpaceObject)bs);
            this.bundleService.update(context, (DSpaceObject)original);
            this.itemService.update(context, (DSpaceObject)item);
            context.restoreAuthSystemState();
            DepositResult result = new DepositResult();
            result.setHandle(urlManager.getBitstreamUrl(bs));
            result.setTreatment(this.getTreatment());
            result.setBitstream(bs);
            return result;
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new DSpaceSWORDException(e);
        }
    }

    private String getTreatment() {
        return "The file has been attached to the specified item";
    }
}

