/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.Depositor;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDIngesterFactory;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class CollectionDepositor
extends Depositor {
    private static Logger log = Logger.getLogger(CollectionDepositor.class);
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private Collection collection;

    public CollectionDepositor(SWORDService swordService, DSpaceObject dso) throws DSpaceSWORDException {
        super(swordService, dso);
        if (!(dso instanceof Collection)) {
            throw new DSpaceSWORDException("You tried to initialise the collection depositor with somethingother than a collection object");
        }
        this.collection = (Collection)dso;
        log.debug((Object)"Created instance of CollectionDepositor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepositResult doDeposit(Deposit deposit) throws SWORDErrorException, DSpaceSWORDException {
        DepositResult result;
        block14: {
            Context context = this.swordService.getContext();
            SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
            SWORDUrlManager urlManager = this.swordService.getUrlManager();
            if (!swordConfig.isAcceptableContentType(context, deposit.getContentType(), (DSpaceObject)this.collection)) {
                log.error((Object)("Unacceptable content type detected: " + deposit.getContentType() + " for collection " + this.collection.getID()));
                throw new SWORDErrorException("http://purl.org/net/sword/error/ErrorContent", "Unacceptable content type in deposit request: " + deposit.getContentType());
            }
            if (!swordConfig.isSupportedMediaType(deposit.getPackaging(), (DSpaceObject)this.collection)) {
                log.error((Object)("Unacceptable packaging type detected: " + deposit.getPackaging() + "for collection" + this.collection.getID()));
                throw new SWORDErrorException("http://purl.org/net/sword/error/ErrorContent", "Unacceptable packaging type in deposit request: " + deposit.getPackaging());
            }
            SWORDIngester si = SWORDIngesterFactory.getInstance((Context)context, (Deposit)deposit, (DSpaceObject)this.collection);
            this.swordService.message("Loaded ingester: " + si.getClass().getName());
            result = si.ingest(this.swordService, deposit, (DSpaceObject)this.collection);
            this.swordService.message("Archive ingest completed successfully");
            try {
                if (swordConfig.isKeepOriginal()) {
                    Bitstream bitstream;
                    this.swordService.message("DSpace will store an original copy of the deposit, as well as ingesting the item into the archive");
                    context.turnOffAuthorisationSystem();
                    String bundleName = ConfigurationManager.getProperty((String)"sword-server", (String)"bundle.name");
                    if (bundleName == null || "".equals(bundleName)) {
                        bundleName = "SWORD";
                    }
                    Item item = result.getItem();
                    List bundles = item.getBundles();
                    Bundle swordBundle = null;
                    for (Bundle bundle : bundles) {
                        if (!bundleName.equals(bundle.getName())) continue;
                        swordBundle = bundle;
                        break;
                    }
                    if (swordBundle == null) {
                        swordBundle = this.bundleService.create(context, item, bundleName);
                    }
                    String fn = this.swordService.getFilename(context, deposit, true);
                    try (FileInputStream fis = null;){
                        fis = new FileInputStream(deposit.getFile());
                        bitstream = this.bitstreamService.create(context, swordBundle, (InputStream)fis);
                    }
                    bitstream.setName(context, fn);
                    bitstream.setDescription(context, "SWORD deposit package");
                    BitstreamFormat bf = this.bitstreamFormatService.findByMIMEType(context, deposit.getContentType());
                    if (bf != null) {
                        this.bitstreamService.setFormat(context, bitstream, bf);
                    }
                    this.bitstreamService.update(context, (DSpaceObject)bitstream);
                    this.bundleService.update(context, (DSpaceObject)swordBundle);
                    this.itemService.update(context, (DSpaceObject)item);
                    this.swordService.message("Original package stored as " + fn + ", in item bundle " + swordBundle);
                    context.restoreAuthSystemState();
                    result.setMediaLink(urlManager.getMediaLink(bitstream));
                    break block14;
                }
                result.setMediaLink(urlManager.getBaseMediaLinkUrl());
            }
            catch (IOException | SQLException | AuthorizeException e) {
                log.error((Object)"caught exception: ", e);
                throw new DSpaceSWORDException(e);
            }
        }
        return result;
    }

    public void undoDeposit(DepositResult result) throws DSpaceSWORDException {
        SWORDContext sc = this.swordService.getSwordContext();
        sc.abort();
        this.swordService.message("Database changes aborted");
    }
}

