/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.sword.DSpaceSWORDException;

public class CollectionLocation {
    public static final Logger log = Logger.getLogger(CollectionLocation.class);
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public String getLocation(Collection collection) throws DSpaceSWORDException {
        return this.getBaseUrl() + "/" + collection.getHandle();
    }

    public Collection getCollection(Context context, String location) throws DSpaceSWORDException {
        try {
            String baseUrl = this.getBaseUrl();
            if (baseUrl.length() == location.length()) {
                throw new DSpaceSWORDException("The deposit URL is incomplete");
            }
            String handle = location.substring(baseUrl.length());
            if (handle.startsWith("/")) {
                handle = handle.substring(1);
            }
            if ("".equals(handle)) {
                throw new DSpaceSWORDException("The deposit URL is incomplete");
            }
            DSpaceObject dso = this.handleService.resolveToObject(context, handle);
            if (!(dso instanceof Collection)) {
                throw new DSpaceSWORDException("The deposit URL does not resolve to a valid collection");
            }
            return (Collection)dso;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception:", (Throwable)e);
            throw new DSpaceSWORDException("There was a problem resolving the collection", (Throwable)e);
        }
    }

    private String getBaseUrl() throws DSpaceSWORDException {
        String depositUrl = ConfigurationManager.getProperty((String)"sword-server", (String)"deposit.url");
        if (depositUrl == null || "".equals(depositUrl)) {
            String dspaceUrl = ConfigurationManager.getProperty((String)"dspace.baseUrl");
            if (dspaceUrl == null || "".equals(dspaceUrl)) {
                throw new DSpaceSWORDException("Unable to construct deposit urls, due to missing/invalid config in sword.deposit.url and/or dspace.baseUrl");
            }
            try {
                URL url = new URL(dspaceUrl);
                depositUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/sword/deposit").toString();
            }
            catch (MalformedURLException e) {
                throw new DSpaceSWORDException("Unable to construct deposit urls, due to invalid dspace.baseUrl " + e.getMessage(), (Throwable)e);
            }
        }
        return depositUrl;
    }
}

