/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.sword.ATOMCollectionGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Collection;

public class CommunityCollectionGenerator
extends ATOMCollectionGenerator {
    private static Logger log = Logger.getLogger(CommunityCollectionGenerator.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();

    public CommunityCollectionGenerator(SWORDService service) {
        super(service);
        log.debug((Object)"Created instance of CommunityCollectionGenerator");
    }

    public Collection buildCollection(DSpaceObject dso) throws DSpaceSWORDException {
        String firstValue;
        List abstracts;
        if (!(dso instanceof Community)) {
            log.error((Object)"buildCollection passed something other than a Community object");
            throw new DSpaceSWORDException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        Community com = (Community)dso;
        Collection scol = new Collection();
        String location = urlManager.getDepositLocation(com);
        scol.setLocation(location);
        String title = this.communityService.getName((DSpaceObject)com);
        if (StringUtils.isNotBlank((String)title)) {
            scol.setTitle(title);
        }
        if ((abstracts = this.communityService.getMetadataByMetadataString((DSpaceObject)com, "short_description")) != null && !abstracts.isEmpty() && StringUtils.isNotBlank((String)(firstValue = ((MetadataValue)abstracts.get(0)).getValue()))) {
            scol.setAbstract(firstValue);
        }
        scol.setMediation(swordConfig.isMediated());
        String subService = urlManager.constructSubServiceUrl(com);
        scol.setService(subService);
        log.debug((Object)"Created ATOM Collection for DSpace Community");
        return scol;
    }
}

