/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.Depositor;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDIngesterFactory;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class ItemDepositor
extends Depositor {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private Item item;

    public ItemDepositor(SWORDService swordService, DSpaceObject dso) throws DSpaceSWORDException {
        super(swordService, dso);
        if (!(dso instanceof Item)) {
            throw new DSpaceSWORDException("You tried to initialise the item depositor with somethingother than an item object");
        }
        this.item = (Item)dso;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepositResult doDeposit(Deposit deposit) throws SWORDErrorException, DSpaceSWORDException {
        DepositResult result;
        block14: {
            Context context = this.swordService.getContext();
            SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
            SWORDUrlManager urlManager = this.swordService.getUrlManager();
            if (!swordConfig.isAcceptableContentType(context, deposit.getContentType(), (DSpaceObject)this.item)) {
                throw new SWORDErrorException("http://purl.org/net/sword/error/ErrorContent", "Unacceptable content type in deposit request: " + deposit.getContentType());
            }
            if (!swordConfig.isSupportedMediaType(deposit.getPackaging(), (DSpaceObject)this.item)) {
                throw new SWORDErrorException("http://purl.org/net/sword/error/ErrorContent", "Unacceptable packaging type in deposit request: " + deposit.getPackaging());
            }
            SWORDIngester si = SWORDIngesterFactory.getInstance((Context)context, (Deposit)deposit, (DSpaceObject)this.item);
            this.swordService.message("Loaded ingester: " + si.getClass().getName());
            result = si.ingest(this.swordService, deposit, (DSpaceObject)this.item);
            this.swordService.message("Archive ingest completed successfully");
            try {
                if (swordConfig.isKeepOriginal()) {
                    Bitstream bitstream;
                    this.swordService.message("DSpace will store an original copy of the deposit file, as well as attaching it to the item");
                    context.turnOffAuthorisationSystem();
                    String bundleName = ConfigurationManager.getProperty((String)"sword-server", (String)"bundle.name");
                    if (StringUtils.isBlank((String)bundleName)) {
                        bundleName = "SWORD";
                    }
                    List bundles = this.item.getBundles();
                    Bundle swordBundle = null;
                    for (Bundle bundle : bundles) {
                        if (!bundleName.equals(bundle.getName())) continue;
                        swordBundle = bundle;
                        break;
                    }
                    if (swordBundle == null) {
                        swordBundle = this.bundleService.create(context, this.item, bundleName);
                    }
                    String fn = this.swordService.getFilename(context, deposit, true);
                    try (FileInputStream fis = null;){
                        fis = new FileInputStream(deposit.getFile());
                        bitstream = this.bitstreamService.create(context, swordBundle, (InputStream)fis);
                    }
                    bitstream.setName(context, fn);
                    bitstream.setDescription(context, "Original file deposited via SWORD");
                    BitstreamFormat bf = this.bitstreamFormatService.findByMIMEType(context, deposit.getContentType());
                    if (bf != null) {
                        this.bitstreamService.setFormat(context, bitstream, bf);
                    }
                    this.bitstreamService.update(context, (DSpaceObject)bitstream);
                    this.bundleService.update(context, (DSpaceObject)swordBundle);
                    this.itemService.update(context, (DSpaceObject)this.item);
                    this.swordService.message("Original package stored as " + fn + ", in item bundle " + swordBundle);
                    context.restoreAuthSystemState();
                    result.setMediaLink(urlManager.getMediaLink(bitstream));
                    break block14;
                }
                result.setMediaLink(urlManager.getMediaLink(result.getBitstream()));
            }
            catch (IOException | SQLException | AuthorizeException e) {
                throw new DSpaceSWORDException(e);
            }
        }
        return result;
    }

    public void undoDeposit(DepositResult result) throws DSpaceSWORDException {
        try {
            SWORDContext sc = this.swordService.getSwordContext();
            BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
            Bitstream bs = result.getBitstream();
            Iterator bundles = bs.getBundles().iterator();
            while (bundles.hasNext()) {
                Bundle bundle = (Bundle)bundles.next();
                bundles.remove();
                bundleService.removeBitstream(sc.getContext(), bundle, bs);
                bundleService.update(sc.getContext(), (DSpaceObject)bundle);
            }
            this.swordService.message("Removing temporary files from disk");
            sc.abort();
            this.swordService.message("Database changes aborted");
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new DSpaceSWORDException(e);
        }
    }
}

