/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword.DSpaceSWORDException;
import org.purl.sword.base.SWORDErrorException;

public class SWORDConfiguration {
    public static final Logger log = Logger.getLogger(SWORDConfiguration.class);
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private boolean noOp = true;
    private boolean verbose = true;
    private int maxUploadSize = -1;
    private boolean mediated = false;
    private boolean keepOriginal = false;
    private String swordBundle = "SWORD";
    private boolean keepPackageOnFailedIngest = false;
    private String failedPackageDir = null;
    private List<String> swordaccepts;

    public SWORDConfiguration() {
        int mus = this.configurationService.getIntProperty("sword-server.max-upload-size");
        if (mus > 0) {
            this.maxUploadSize = mus;
        }
        this.mediated = this.configurationService.getBooleanProperty("sword-server.on-behalf-of.enable");
        this.keepOriginal = this.configurationService.getBooleanProperty("sword-server.keep-original-package");
        String bundle = this.configurationService.getProperty("sword-server.bundle.name");
        if (bundle != null && "".equals(bundle)) {
            this.swordBundle = bundle;
        }
        this.keepPackageOnFailedIngest = this.configurationService.getBooleanProperty("sword-server.keep-package-on-fail", false);
        this.failedPackageDir = this.configurationService.getProperty("sword-server.failed-package.dir");
        String[] acceptsFormats = this.configurationService.getArrayProperty("sword-server.accepts");
        this.swordaccepts = new ArrayList();
        if (acceptsFormats == null) {
            acceptsFormats = new String[]{"application/zip"};
        }
        for (String element : acceptsFormats) {
            this.swordaccepts.add(element.trim());
        }
    }

    public String getSwordBundle() {
        return this.swordBundle;
    }

    public void setSwordBundle(String swordBundle) {
        this.swordBundle = swordBundle;
    }

    public boolean isNoOp() {
        return this.noOp;
    }

    public void setNoOp(boolean noOp) {
        this.noOp = noOp;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public boolean isMediated() {
        return this.mediated;
    }

    public void setMediated(boolean mediated) {
        this.mediated = mediated;
    }

    public boolean isKeepOriginal() {
        return this.keepOriginal;
    }

    public void setKeepOriginal(boolean keepOriginal) {
        this.keepOriginal = keepOriginal;
    }

    public void setKeepPackageOnFailedIngest(boolean keepOriginalOnFail) {
        this.keepPackageOnFailedIngest = keepOriginalOnFail;
    }

    public boolean isKeepPackageOnFailedIngest() {
        return this.keepPackageOnFailedIngest;
    }

    public void setFailedPackageDir(String dir) {
        this.failedPackageDir = dir;
    }

    public String getFailedPackageDir() {
        return this.failedPackageDir;
    }

    public List<String> getAccepts(Context context, DSpaceObject dso) throws DSpaceSWORDException {
        try {
            ArrayList<String> accepts = new ArrayList<String>();
            if (dso instanceof Collection) {
                for (String format : this.swordaccepts) {
                    accepts.add(format);
                }
            } else if (dso instanceof Item) {
                List bfs = this.bitstreamFormatService.findNonInternal(context);
                for (BitstreamFormat bf : bfs) {
                    accepts.add(bf.getMIMEType());
                }
            }
            return accepts;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public List<String> getCollectionAccepts() throws DSpaceSWORDException {
        ArrayList<String> accepts = new ArrayList<String>();
        for (String format : this.swordaccepts) {
            accepts.add(format);
        }
        return accepts;
    }

    public Map<String, Float> getAcceptPackaging(Collection col) {
        HashMap<String, String> identifiers = new HashMap<String, String>();
        HashMap<String, String> qs = new HashMap<String, String>();
        String handle = col.getHandle();
        String acceptPackagingPrefix = "sword-server.accept-packaging";
        List keys = this.configurationService.getPropertyKeys(acceptPackagingPrefix);
        for (String key : keys) {
            String value;
            String suffix = key.substring(acceptPackagingPrefix.length() + 1);
            String[] bits = suffix.split("\\.");
            if (bits.length == 2) {
                value = this.configurationService.getProperty(key);
                if (bits[1].equals("identifier")) {
                    identifiers.put(bits[0], value);
                } else if (bits[1].equals("q")) {
                    qs.put(bits[0], value);
                }
            }
            if (bits.length != 3 || !bits[0].equals(handle)) continue;
            value = this.configurationService.getProperty(key);
            if (bits[2].equals("identifier")) {
                identifiers.put(bits[1], value);
                continue;
            }
            if (!bits[2].equals("q")) continue;
            qs.put(bits[1], value);
        }
        HashMap<String, Float> ap = new HashMap<String, Float>();
        for (String ik : identifiers.keySet()) {
            String id = (String)identifiers.get(ik);
            String qv = (String)qs.get(ik);
            Float qf = Float.valueOf(Float.parseFloat(qv));
            ap.put(id, qf);
        }
        return ap;
    }

    public boolean isSupportedMediaType(String mediaType, DSpaceObject dso) throws DSpaceSWORDException, SWORDErrorException {
        if (mediaType == null || "".equals(mediaType)) {
            return true;
        }
        if (dso instanceof Collection) {
            Map accepts = this.getAcceptPackaging((Collection)dso);
            for (String accept : accepts.keySet()) {
                if (!accept.equals(mediaType)) continue;
                return true;
            }
        } else if (dso instanceof Item) {
            return true;
        }
        return false;
    }

    public boolean isAcceptableContentType(Context context, String type, DSpaceObject dso) throws DSpaceSWORDException {
        List accepts = this.getAccepts(context, dso);
        return accepts.contains(type);
    }

    public String getTempDir() throws DSpaceSWORDException {
        return this.configurationService.getProperty("upload.temp.dir") != null ? this.configurationService.getProperty("upload.temp.dir") : System.getProperty("java.io.tmpdir");
    }
}

