/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Deposit;

public class SWORDService {
    public static final Logger log = Logger.getLogger(SWORDService.class);
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private SWORDContext swordContext;
    private SWORDConfiguration swordConfig;
    private SWORDUrlManager urlManager;
    private StringBuilder verboseDescription = new StringBuilder();
    private boolean verbose = false;
    private SimpleDateFormat dateFormat;

    public SWORDService(SWORDContext sc) {
        this.swordContext = sc;
        this.swordConfig = new SWORDConfiguration();
        this.urlManager = new SWORDUrlManager(this.swordConfig, this.swordContext.getContext());
        this.dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.S]");
    }

    public SWORDUrlManager getUrlManager() {
        return this.urlManager;
    }

    public void setUrlManager(SWORDUrlManager urlManager) {
        this.urlManager = urlManager;
    }

    public SWORDContext getSwordContext() {
        return this.swordContext;
    }

    public void setSwordContext(SWORDContext swordContext) {
        this.swordContext = swordContext;
    }

    public SWORDConfiguration getSwordConfig() {
        return this.swordConfig;
    }

    public void setSwordConfig(SWORDConfiguration swordConfig) {
        this.swordConfig = swordConfig;
    }

    public Context getContext() {
        return this.swordContext.getContext();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public StringBuilder getVerboseDescription() {
        return this.verboseDescription;
    }

    public void message(String message) {
        String msg = this.dateFormat.format(new Date()) + " " + message + "; \n\n";
        if (this.verbose) {
            this.verboseDescription.append(msg);
        }
        log.info((Object)msg);
    }

    public String getFilename(Context context, Deposit deposit, boolean original) throws DSpaceSWORDException {
        try {
            String fn;
            BitstreamFormat bf = this.bitstreamFormatService.findByMIMEType(context, deposit.getContentType());
            List exts = null;
            if (bf != null) {
                exts = bf.getExtensions();
            }
            if ((fn = deposit.getFilename()) == null || "".equals(fn)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                fn = "sword-" + sdf.format(new Date());
                if (original) {
                    fn = fn + ".original";
                }
                if (exts != null && !exts.isEmpty()) {
                    fn = fn + "." + (String)exts.get(0);
                }
            }
            return fn;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    public String getTempFilename() {
        return "sword-" + new Date().getTime();
    }
}

