/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.sword.ATOMCollectionGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Collection;

public class ItemCollectionGenerator
extends ATOMCollectionGenerator {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public ItemCollectionGenerator(SWORDService service) {
        super(service);
    }

    public Collection buildCollection(DSpaceObject dso) throws DSpaceSWORDException {
        String firstValue;
        String firstValue2;
        if (!(dso instanceof Item)) {
            throw new DSpaceSWORDException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        Context context = this.swordService.getContext();
        Item item = (Item)dso;
        Collection scol = new Collection();
        String location = urlManager.getDepositLocation(item);
        scol.setLocation(location);
        String title = "Untitled";
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.title");
        if (!dcv.isEmpty() && StringUtils.isNotBlank((CharSequence)(firstValue2 = ((MetadataValue)dcv.get(0)).getValue()))) {
            title = firstValue2;
        }
        scol.setTitle(title);
        String dcAbstract = "";
        List dcva = this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.description.abstract");
        if (!dcva.isEmpty() && StringUtils.isNotBlank((CharSequence)(firstValue = ((MetadataValue)dcva.get(0)).getValue()))) {
            dcAbstract = firstValue;
        }
        if (StringUtils.isNotBlank((CharSequence)dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(swordConfig.isMediated());
        List acceptFormats = swordConfig.getAccepts(context, (DSpaceObject)item);
        for (String acceptFormat : acceptFormats) {
            scol.addAccepts(acceptFormat);
        }
        return scol;
    }
}

