/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.sword.DSpaceATOMEntry;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.atom.Content;
import org.purl.sword.atom.ContentType;
import org.purl.sword.atom.InvalidMediaTypeException;
import org.purl.sword.atom.Link;
import org.purl.sword.atom.Rights;
import org.purl.sword.atom.Summary;
import org.purl.sword.atom.Title;

public class ItemEntryGenerator
extends DSpaceATOMEntry {
    private static Logger log = LogManager.getLogger(ItemEntryGenerator.class);
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    protected ItemEntryGenerator(SWORDService service) {
        super(service);
    }

    protected void addCategories() {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)this.item, "dc.subject.*");
        if (dcv != null) {
            for (MetadataValue aDcv : dcv) {
                this.entry.addCategory(aDcv.getValue());
            }
        }
    }

    protected void addContentElement() throws DSpaceSWORDException {
        block9: {
            SWORDUrlManager urlManager = this.swordService.getUrlManager();
            try {
                if (this.deposit.isNoOp()) break block9;
                String handle = "";
                if (this.item.getHandle() != null) {
                    handle = this.item.getHandle();
                }
                if (!StringUtils.isNotBlank((CharSequence)handle)) break block9;
                boolean keepOriginal = ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"keep-original-package");
                String swordBundle = ConfigurationManager.getProperty((String)"sword-server", (String)"bundle.name");
                if (StringUtils.isBlank((CharSequence)swordBundle)) {
                    swordBundle = "SWORD";
                }
                if (keepOriginal) {
                    Content con = new Content();
                    List bundles = this.item.getBundles();
                    for (Bundle bundle : bundles) {
                        if (!swordBundle.equals(bundle.getName())) continue;
                        List bss = bundle.getBitstreams();
                        for (Bitstream bs : bss) {
                            BitstreamFormat bf = bs.getFormat(this.swordService.getContext());
                            String format = "application/octet-stream";
                            if (bf != null) {
                                format = bf.getMIMEType();
                            }
                            con.setType(format);
                            String bsLink = urlManager.getBitstreamUrl(bs);
                            con.setSource(bsLink);
                            this.entry.setContent(con);
                        }
                        break block9;
                    }
                    break block9;
                }
                Content content = new Content();
                content.setType("text/html");
                content.setSource(this.handleService.getCanonicalForm(handle));
                this.entry.setContent(content);
            }
            catch (InvalidMediaTypeException handle) {
            }
            catch (SQLException e) {
                log.error("caught exception: ", (Throwable)e);
                throw new DSpaceSWORDException((Throwable)e);
            }
        }
    }

    protected void addIdentifier() {
        if (!this.deposit.isNoOp()) {
            String handle = "";
            if (this.item.getHandle() != null) {
                handle = this.item.getHandle();
            }
            if (StringUtils.isNotBlank((CharSequence)handle)) {
                this.entry.setId(this.handleService.getCanonicalForm(handle));
                return;
            }
        }
        String cfg = ConfigurationManager.getProperty((String)"dspace.url");
        this.entry.setId(cfg);
    }

    protected void addLinks() throws DSpaceSWORDException {
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        try {
            String handle = "";
            if (this.item.getHandle() == null) {
                return;
            }
            handle = this.item.getHandle();
            List bundles = this.item.getBundles();
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                List bss = bundle.getBitstreams();
                for (Bitstream bs : bss) {
                    Link link = new Link();
                    String url = urlManager.getBitstreamUrl(bs);
                    link.setHref(url);
                    link.setRel("part");
                    BitstreamFormat bsf = bs.getFormat(this.swordService.getContext());
                    if (bsf != null) {
                        link.setType(bsf.getMIMEType());
                    }
                    this.entry.addLink(link);
                }
            }
            Link splash = new Link();
            splash.setHref(this.handleService.getCanonicalForm(handle));
            splash.setRel("alternate");
            splash.setType("text/html");
            this.entry.addLink(splash);
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    protected void addPublishDate() {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)this.item, "dc.date.issued");
        if (dcv != null && !dcv.isEmpty()) {
            this.entry.setPublished(((MetadataValue)dcv.get(0)).getValue());
        }
    }

    protected void addRights() throws DSpaceSWORDException {
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        String handle = this.item.getHandle();
        if (StringUtils.isBlank((CharSequence)handle)) {
            return;
        }
        String base = ConfigurationManager.getProperty((String)"dspace.url");
        if (base == null) {
            return;
        }
        StringBuilder rightsString = new StringBuilder();
        List bundles = this.item.getBundles();
        for (Bundle bundle : bundles) {
            if (!"LICENSE".equals(bundle.getName())) continue;
            List bss = bundle.getBitstreams();
            for (Bitstream bs : bss) {
                String url = urlManager.getBitstreamUrl(bs);
                rightsString.append(url).append(" ");
            }
        }
        Rights rights = new Rights();
        rights.setContent(rightsString.toString());
        rights.setType(ContentType.TEXT);
        this.entry.setRights(rights);
    }

    protected void addSummary() {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)this.item, "dc.description.abstract");
        if (dcv != null) {
            for (MetadataValue aDcv : dcv) {
                Summary summary = new Summary();
                summary.setContent(aDcv.getValue());
                summary.setType(ContentType.TEXT);
                this.entry.setSummary(summary);
            }
        }
    }

    protected void addTitle() {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)this.item, "dc.title");
        if (dcv != null) {
            for (MetadataValue aDcv : dcv) {
                Title title = new Title();
                title.setContent(aDcv.getValue());
                title.setType(ContentType.TEXT);
                this.entry.setTitle(title);
            }
        }
    }

    protected void addLastUpdatedDate() {
        String config = ConfigurationManager.getProperty((String)"sword-server", (String)"updated.field");
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)this.item, config);
        if (dcv != null && dcv.size() == 1) {
            DCDate dcd = new DCDate(((MetadataValue)dcv.get(0)).getValue());
            this.entry.setUpdated(dcd.toString());
        }
    }
}

