/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.atom.Author;
import org.purl.sword.atom.Content;
import org.purl.sword.atom.Contributor;
import org.purl.sword.atom.Generator;
import org.purl.sword.atom.Link;
import org.purl.sword.atom.Rights;
import org.purl.sword.atom.Summary;
import org.purl.sword.atom.Title;
import org.purl.sword.base.Collection;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.SwordAcceptPackaging;
import org.purl.sword.base.Workspace;
import org.purl.sword.client.Client;
import org.purl.sword.client.ClientOptions;
import org.purl.sword.client.ClientType;
import org.purl.sword.client.PostDestination;
import org.purl.sword.client.PostMessage;
import org.purl.sword.client.SWORDClient;
import org.purl.sword.client.SWORDClientException;
import org.purl.sword.client.Status;

public class CmdClient
implements ClientType {
    private SWORDClient client = new Client();
    private ClientOptions options;
    private static Logger log = LogManager.getLogger(CmdClient.class);

    public void process() {
        if (this.options.getProxyHost() != null) {
            this.client.setProxy(this.options.getProxyHost(), this.options.getProxyPort());
        }
        try {
            String accessType = this.options.getAccessType();
            if ("service".equals(accessType)) {
                this.service();
            } else if ("post".equals(accessType)) {
                this.post();
            } else if ("multipost".equals(accessType)) {
                System.out.println("checking multi-post");
                this.multiPost();
            } else {
                System.out.println("Access type not recognised.");
            }
        }
        catch (MalformedURLException mex) {
            System.out.println("The specified href was not valid: " + this.options.getHref() + " message: " + mex.getMessage());
        }
        catch (SWORDClientException ex) {
            System.out.println("Exception: " + ex.getMessage());
            log.error("Unable to process request", (Throwable)ex);
        }
    }

    private void service() throws SWORDClientException, MalformedURLException {
        String href = this.options.getHref();
        this.initialiseServer(href, this.options.getUsername(), this.options.getPassword());
        ServiceDocument document = this.client.getServiceDocument(href, this.options.getOnBehalfOf());
        Status status = this.client.getStatus();
        System.out.println("The status is: " + status);
        if (status.getCode() == 200) {
            log.debug("message is: " + document.marshall());
            System.out.println("\nThe following Details were retrieved: ");
            System.out.println("SWORD Version: " + document.getService().getVersion());
            System.out.println("Supports NoOp? " + document.getService().isNoOp());
            System.out.println("Supports Verbose? " + document.getService().isVerbose());
            System.out.println("Max Upload File Size " + document.getService().getMaxUploadSize() + " kB");
            Iterator workspaces = document.getService().getWorkspaces();
            while (workspaces.hasNext()) {
                Workspace workspace = (Workspace)workspaces.next();
                System.out.println("\nWorkspace Title: '" + workspace.getTitle() + "'");
                System.out.println("\n+ Collections ---");
                Iterator collections = workspace.collectionIterator();
                while (collections.hasNext()) {
                    Collection collection = (Collection)collections.next();
                    System.out.println("\nCollection location: " + collection.getLocation());
                    System.out.println("Collection title: " + collection.getTitle());
                    System.out.println("Abstract: " + collection.getAbstract());
                    System.out.println("Collection Policy: " + collection.getCollectionPolicy());
                    System.out.println("Treatment: " + collection.getTreatment());
                    System.out.println("Mediation: " + collection.getMediation());
                    String[] accepts = collection.getAccepts();
                    if (accepts != null && accepts.length == 0) {
                        System.out.println("Accepts: none specified");
                    } else {
                        for (String s : accepts) {
                            System.out.println("Accepts: " + s);
                        }
                    }
                    List acceptsPackaging = collection.getAcceptPackaging();
                    StringBuilder acceptPackagingList = new StringBuilder();
                    for (SwordAcceptPackaging accept : acceptsPackaging) {
                        acceptPackagingList.append(accept.getContent()).append(" (").append(accept.getQualityValue()).append("), ").toString();
                    }
                    System.out.println("Accepts Packaging: " + acceptPackagingList.toString());
                }
                System.out.println("+ End of Collections ---");
            }
        }
    }

    private void post() throws SWORDClientException, MalformedURLException {
        String type;
        String url = this.options.getHref();
        if (url == null) {
            url = this.readLine("Please enter the URL for the deposit: ");
        }
        this.initialiseServer(url, this.options.getUsername(), this.options.getPassword());
        String file = this.options.getFilename();
        if (file == null) {
            file = this.readLine("Please enter the filename to deposit: ");
        }
        if ((type = this.options.getFiletype()) == null) {
            type = this.readLine("Please enter the file type, e.g. application/zip: ");
        }
        PostMessage message = new PostMessage();
        message.setFilepath(file);
        message.setDestination(url);
        message.setFiletype(type);
        message.setUseMD5(this.options.isMd5());
        message.setVerbose(this.options.isVerbose());
        message.setNoOp(this.options.isNoOp());
        message.setFormatNamespace(this.options.getFormatNamespace());
        message.setOnBehalfOf(this.options.getOnBehalfOf());
        message.setChecksumError(this.options.getChecksumError());
        message.setUserAgent("CASIS Test Client");
        this.processPost(message);
    }

    private void multiPost() throws SWORDClientException, MalformedURLException {
        String type;
        String file = this.options.getFilename();
        if (file == null) {
            file = this.readLine("Please enter the filename to deposit: ");
        }
        if ((type = this.options.getFiletype()) == null) {
            type = this.readLine("Please enter the file type, e.g. application/zip: ");
        }
        String url = null;
        Iterator iterator = this.options.getMultiPost();
        while (iterator.hasNext()) {
            PostDestination destination = (PostDestination)iterator.next();
            url = destination.getUrl();
            this.initialiseServer(url, destination.getUsername(), destination.getPassword());
            String onBehalfOf = destination.getOnBehalfOf();
            onBehalfOf = onBehalfOf == null ? "" : " on behalf of: " + onBehalfOf;
            System.out.println("Sending file to: " + url + " for: " + destination.getUsername() + onBehalfOf);
            PostMessage message = new PostMessage();
            message.setFilepath(file);
            message.setDestination(url);
            message.setFiletype(type);
            message.setUseMD5(this.options.isMd5());
            message.setVerbose(this.options.isVerbose());
            message.setNoOp(this.options.isNoOp());
            message.setFormatNamespace(this.options.getFormatNamespace());
            message.setOnBehalfOf(destination.getOnBehalfOf());
            message.setChecksumError(this.options.getChecksumError());
            message.setUserAgent("CASIS Test Client");
            this.processPost(message);
        }
    }

    protected void processPost(PostMessage message) throws SWORDClientException {
        DepositResponse response = this.client.postFile(message);
        System.out.println("The status is: " + this.client.getStatus());
        if (response != null) {
            log.debug("message is: " + response.marshall());
            SWORDEntry entry = response.getEntry();
            System.out.println("Id: " + entry.getId());
            Title title = entry.getTitle();
            if (title != null) {
                System.out.print("Title: " + title.getContent() + " type: ");
                if (title.getType() != null) {
                    System.out.println(title.getType().toString());
                } else {
                    System.out.println("Not specified.");
                }
            }
            Iterator authors = entry.getAuthors();
            while (authors.hasNext()) {
                Author author = (Author)authors.next();
                System.out.println("Author - " + author.toString());
            }
            Iterator categories = entry.getCategories();
            while (categories.hasNext()) {
                System.out.println("Category: " + (String)categories.next());
            }
            Iterator contributors = entry.getContributors();
            while (contributors.hasNext()) {
                Contributor contributor = (Contributor)contributors.next();
                System.out.println("Contributor - " + contributor.toString());
            }
            Iterator links = entry.getLinks();
            while (links.hasNext()) {
                Link link = (Link)links.next();
                System.out.println(link.toString());
            }
            Generator generator = entry.getGenerator();
            if (generator != null) {
                System.out.println("Generator - " + generator.toString());
            } else {
                System.out.println("There is no generator");
            }
            System.out.println("Published: " + entry.getPublished());
            Content content = entry.getContent();
            if (content != null) {
                System.out.println(content.toString());
            } else {
                System.out.println("There is no content element.");
            }
            Rights right = entry.getRights();
            if (right != null) {
                System.out.println(right.toString());
            } else {
                System.out.println("There is no right element.");
            }
            Summary summary = entry.getSummary();
            if (summary != null) {
                System.out.println(summary.toString());
            } else {
                System.out.println("There is no summary element.");
            }
            System.out.println("Update: " + entry.getUpdated());
            System.out.println("Published: " + entry.getPublished());
            System.out.println("Verbose Description: " + entry.getVerboseDescription());
            System.out.println("Treatment: " + entry.getTreatment());
            System.out.println("Packaging: " + entry.getPackaging());
            if (entry.isNoOpSet()) {
                System.out.println("NoOp: " + entry.isNoOp());
            }
        } else {
            System.out.println("No valid Entry document was received from the server");
        }
    }

    private void initialiseServer(String location, String username, String password) throws MalformedURLException {
        URL url = new URL(location);
        int port = url.getPort();
        if (port == -1) {
            port = 80;
        }
        this.client.setServer(url.getHost(), port);
        if (username != null && username.length() > 0 && password != null && password.length() > 0) {
            log.info("Setting the username/password: " + username + " " + password);
            this.client.setCredentials(username, password);
        } else {
            this.client.clearCredentials();
        }
    }

    private String readLine(String prompt) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String result = null;
        boolean ok = false;
        while (!ok) {
            try {
                System.out.print(prompt);
                System.out.flush();
                result = reader.readLine();
                ok = true;
            }
            catch (IOException ex) {
                System.out.println("There was an error with your input. Please try again.");
            }
        }
        return result;
    }

    public void run(ClientOptions options) {
        this.options = options;
        this.process();
    }
}

