/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;

public class WorkflowTools {
    public boolean isItemInWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            String query = "SELECT workflow_id FROM workflowitem WHERE item_id = ?";
            Object[] params = new Object[]{item.getID()};
            TableRowIterator tri = DatabaseManager.query((Context)context, (String)query, (Object[])params);
            if (tri.hasNext()) {
                tri.close();
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public boolean isItemInWorkspace(Context context, Item item) throws DSpaceSwordException {
        try {
            String query = "SELECT workspace_item_id FROM workspaceitem WHERE item_id = ?";
            Object[] params = new Object[]{item.getID()};
            TableRowIterator tri = DatabaseManager.query((Context)context, (String)query, (Object[])params);
            if (tri.hasNext()) {
                tri.close();
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public WorkflowItem getWorkflowItem(Context context, Item item) throws DSpaceSwordException {
        try {
            String query = "SELECT workflow_id FROM workflowitem WHERE item_id = ?";
            Object[] params = new Object[]{item.getID()};
            TableRowIterator tri = DatabaseManager.query((Context)context, (String)query, (Object[])params);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int wfid = row.getIntColumn("workflow_id");
                WorkflowItem wfi = WorkflowItem.find((Context)context, (int)wfid);
                tri.close();
                return wfi;
            }
            return null;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public WorkspaceItem getWorkspaceItem(Context context, Item item) throws DSpaceSwordException {
        try {
            String query = "SELECT workspace_item_id FROM workspaceitem WHERE item_id = ?";
            Object[] params = new Object[]{item.getID()};
            TableRowIterator tri = DatabaseManager.query((Context)context, (String)query, (Object[])params);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int wsid = row.getIntColumn("workspace_item_id");
                WorkspaceItem wsi = WorkspaceItem.find((Context)context, (int)wsid);
                tri.close();
                return wsi;
            }
            return null;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public void startWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            WorkspaceItem wsi = this.getWorkspaceItem(context, item);
            boolean notify = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"workflow.notify");
            if (notify) {
                WorkflowManager.start((Context)context, (WorkspaceItem)wsi);
            } else {
                WorkflowManager.startWithoutNotify((Context)context, (WorkspaceItem)wsi);
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public void stopWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            WorkflowItem wfi = this.getWorkflowItem(context, item);
            if (wfi != null) {
                WorkflowManager.abort((Context)context, (WorkflowItem)wfi, (EPerson)context.getCurrentUser());
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }
}

