/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;

public class SwordConfigurationDSpace
implements SwordConfiguration {
    public static final Logger log = Logger.getLogger(SwordConfigurationDSpace.class);
    private boolean verbose = true;
    private int maxUploadSize = -1;
    private boolean mediated = false;
    private boolean keepOriginal = false;
    private String swordBundle = "SWORD";
    private boolean keepPackageOnFailedIngest = false;
    private String failedPackageDir = null;
    private boolean allowCommunityDeposit = false;
    private boolean entryFirst = false;
    private List<String> swordaccepts;

    public SwordConfigurationDSpace() {
        int mus = ConfigurationManager.getIntProperty((String)"swordv2-server", (String)"max-upload-size");
        if (mus > 0) {
            this.maxUploadSize = mus;
        }
        this.mediated = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"on-behalf-of.enable");
        this.keepOriginal = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"keep-original-package");
        String bundle = ConfigurationManager.getProperty((String)"swordv2-server", (String)"bundle.name");
        if (bundle != null && "".equals(bundle)) {
            this.swordBundle = bundle;
        }
        this.keepPackageOnFailedIngest = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"keep-package-on-fail", (boolean)false);
        this.failedPackageDir = ConfigurationManager.getProperty((String)"swordv2-server", (String)"failed-package.dir");
        String acceptsProperty = ConfigurationManager.getProperty((String)"swordv2-server", (String)"accepts");
        this.swordaccepts = new ArrayList();
        if (acceptsProperty == null) {
            acceptsProperty = "application/zip";
        }
        for (String element : acceptsProperty.split(",")) {
            this.swordaccepts.add(element.trim());
        }
        this.allowCommunityDeposit = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"allow-community-deposit");
        this.entryFirst = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"multipart.entry-first", (boolean)false);
    }

    public String getStringProperty(String module, String propName, String defaultValue, String[] allowedValues) {
        String cfg = module == null ? ConfigurationManager.getProperty((String)propName) : ConfigurationManager.getProperty((String)module, (String)propName);
        if (cfg == null || "".equals(cfg)) {
            return defaultValue;
        }
        boolean allowed = false;
        if (allowedValues != null) {
            for (String value : allowedValues) {
                if (!cfg.equals(value)) continue;
                allowed = true;
            }
        } else {
            allowed = true;
        }
        if (allowed) {
            return cfg;
        }
        return defaultValue;
    }

    public String getStringProperty(String module, String propName, String defaultValue) {
        return this.getStringProperty(module, propName, defaultValue, null);
    }

    public boolean returnDepositReceipt() {
        return true;
    }

    public boolean returnStackTraceInError() {
        return true;
    }

    public boolean returnErrorBody() {
        return true;
    }

    public String generator() {
        return this.getStringProperty("swordv2-server", "generator.url", "http://www.dspace.org/ns/sword/2.0/");
    }

    public String generatorVersion() {
        return this.getStringProperty("swordv2-server", "generator.version", "2.0");
    }

    public String administratorEmail() {
        return this.getStringProperty(null, "mail.admin", null);
    }

    public String getAuthType() {
        return this.getStringProperty("swordv2-server", "auth-type", "Basic", new String[]{"Basic", "None"});
    }

    public boolean storeAndCheckBinary() {
        return true;
    }

    public String getTempDirectory() {
        return this.getStringProperty("swordv2-server", "upload.tempdir", null);
    }

    public SwordUrlManager getUrlManager(Context context, SwordConfigurationDSpace config) {
        return new SwordUrlManager(config, context);
    }

    public List<String> getDisseminatePackaging() {
        ArrayList<String> dps = new ArrayList<String>();
        Properties props = ConfigurationManager.getProperties((String)"swordv2-server");
        Set<Object> keyset = props.keySet();
        for (Object keyObj : keyset) {
            String key;
            String sw = "disseminate-packaging.";
            if (!(keyObj instanceof String) || !(key = (String)keyObj).startsWith(sw)) continue;
            String value = props.getProperty(key);
            dps.add(value);
        }
        return dps;
    }

    public boolean isEntryFirst() {
        return this.entryFirst;
    }

    public boolean allowCommunityDeposit() {
        return this.allowCommunityDeposit;
    }

    public String getSwordBundle() {
        return this.swordBundle;
    }

    public void setSwordBundle(String swordBundle) {
        this.swordBundle = swordBundle;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public boolean isMediated() {
        return this.mediated;
    }

    public void setMediated(boolean mediated) {
        this.mediated = mediated;
    }

    public boolean isKeepOriginal() {
        return this.keepOriginal;
    }

    public void setKeepOriginal(boolean keepOriginal) {
        this.keepOriginal = keepOriginal;
    }

    public void setKeepPackageOnFailedIngest(boolean keepOriginalOnFail) {
        this.keepPackageOnFailedIngest = keepOriginalOnFail;
    }

    public boolean isKeepPackageOnFailedIngest() {
        return this.keepPackageOnFailedIngest;
    }

    public void setFailedPackageDir(String dir) {
        this.failedPackageDir = dir;
    }

    public String getFailedPackageDir() {
        return this.failedPackageDir;
    }

    public List<String> getAccepts(Context context, DSpaceObject dso) throws DSpaceSwordException {
        try {
            ArrayList<String> accepts = new ArrayList<String>();
            if (dso instanceof Collection) {
                for (String format : this.swordaccepts) {
                    accepts.add(format);
                }
            } else if (dso instanceof Item) {
                BitstreamFormat[] bfs = BitstreamFormat.findNonInternal((Context)context);
                for (int i = 0; i < bfs.length; ++i) {
                    accepts.add(bfs[i].getMIMEType());
                }
                for (String format : this.swordaccepts) {
                    if (accepts.contains(format)) continue;
                    accepts.add(format);
                }
            }
            return accepts;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public List<String> getCollectionAccepts() throws DSpaceSwordException {
        ArrayList<String> accepts = new ArrayList<String>();
        for (String format : this.swordaccepts) {
            accepts.add(format);
        }
        return accepts;
    }

    public List<String> getAcceptPackaging(Collection col) {
        String handle = col.getHandle();
        ArrayList<String> aps = new ArrayList<String>();
        Properties props = ConfigurationManager.getProperties((String)"swordv2-server");
        Set<Object> keyset = props.keySet();
        for (Object keyObj : keyset) {
            String key;
            String sw = "accept-packaging.collection.";
            if (!(keyObj instanceof String) || !(key = (String)keyObj).startsWith(sw)) continue;
            String suffix = key.substring(sw.length());
            boolean withHandle = false;
            if (suffix.startsWith(handle)) {
                withHandle = true;
            }
            boolean general = false;
            if (suffix.indexOf(".") == -1) {
                general = true;
            }
            if (!withHandle && !general) continue;
            String value = props.getProperty(key);
            aps.add(value);
        }
        return aps;
    }

    public List<String> getItemAcceptPackaging() {
        ArrayList<String> aps = new ArrayList<String>();
        Properties props = ConfigurationManager.getProperties((String)"swordv2-server");
        Set<Object> keyset = props.keySet();
        for (Object keyObj : keyset) {
            String key;
            String sw = "accept-packaging.item.";
            if (!(keyObj instanceof String) || !(key = (String)keyObj).startsWith(sw)) continue;
            String value = props.getProperty(key);
            aps.add(value);
        }
        return aps;
    }

    public boolean isAcceptedPackaging(String packageFormat, DSpaceObject dso) throws DSpaceSwordException, SwordError {
        block4: {
            block3: {
                if (packageFormat == null || "".equals(packageFormat)) {
                    return true;
                }
                if (!(dso instanceof Collection)) break block3;
                List accepts = this.getAcceptPackaging((Collection)dso);
                for (String accept : accepts) {
                    if (!accept.equals(packageFormat)) continue;
                    return true;
                }
                break block4;
            }
            if (!(dso instanceof Item)) break block4;
            List accepts = this.getItemAcceptPackaging();
            for (String accept : accepts) {
                if (!accept.equals(packageFormat)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAcceptableContentType(Context context, String type, DSpaceObject dso) throws DSpaceSwordException {
        List accepts = this.getAccepts(context, dso);
        return accepts.contains(type);
    }

    public String getStateUri(String state) {
        return ConfigurationManager.getProperty((String)"swordv2-server", (String)("state." + state + ".uri"));
    }

    public String getStateDescription(String state) {
        return ConfigurationManager.getProperty((String)"swordv2-server", (String)("state." + state + ".description"));
    }
}

