/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;

public class VersionManager {
    public void removeBundle(Item item, String name) throws SQLException, AuthorizeException, IOException {
        Bundle[] bundles;
        boolean keep = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"versions.keep");
        for (Bundle b : bundles = item.getBundles(name)) {
            this.removeBundle(item, b, keep);
        }
    }

    public void removeBundle(Item item, Bundle source) throws SQLException, AuthorizeException, IOException {
        boolean keep = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"versions.keep");
        this.removeBundle(item, source, keep);
    }

    public void removeBundle(Item item, Bundle source, boolean archive) throws SQLException, AuthorizeException, IOException {
        if (archive) {
            this.archiveBundle(item, source);
        }
        for (Bitstream bitstream : source.getBitstreams()) {
            source.removeBitstream(bitstream);
        }
        item.removeBundle(source);
    }

    public void removeBitstream(Item item, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        boolean keep = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"versions.keep");
        this.removeBitstream(item, bitstream, keep);
    }

    public void removeBitstream(Item item, Bitstream bitstream, boolean keep) throws SQLException, AuthorizeException, IOException {
        Bundle[] bundles;
        Bundle exempt = null;
        if (keep) {
            exempt = this.archiveBitstream(item, bitstream);
        }
        for (Bundle bundle : bundles = bitstream.getBundles()) {
            if (exempt == null || bundle.getID() == exempt.getID()) continue;
            bundle.removeBitstream(bitstream);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String desc = bitstream.getDescription();
        String newDesc = "[Deleted on: " + sdf.format(new Date()) + "] ";
        if (desc != null) {
            newDesc = newDesc + desc;
        }
        bitstream.setDescription(newDesc);
        bitstream.update();
    }

    private Bundle archiveBitstream(Item item, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        String swordBundle = ConfigurationManager.getProperty((String)"swordv2-server", (String)"bundle.deleted");
        if (swordBundle == null) {
            swordBundle = "DELETED";
        }
        Bundle[] swords = item.getBundles(swordBundle);
        Bundle archive = null;
        archive = swords.length == 0 ? item.createBundle(swordBundle) : swords[0];
        this.archiveBitstream(archive, bitstream);
        return archive;
    }

    private void archiveBitstream(Bundle target, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        target.addBitstream(bitstream);
    }

    private void archiveBundle(Item item, Bundle source) throws SQLException, AuthorizeException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String oldName = "VER" + sdf.format(new Date());
        oldName = this.getNumberedName(item, oldName, 0);
        Bundle old = item.createBundle(oldName);
        for (Bitstream bitstream : source.getBitstreams()) {
            old.addBitstream(bitstream);
        }
    }

    private String getNumberedName(Item item, String name, int number) throws SQLException {
        String nName = name + "." + Integer.toString(number);
        if (item.getBundles(nName) == null || item.getBundles(nName).length == 0) {
            return nName;
        }
        return this.getNumberedName(item, name, number + 1);
    }
}

