/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import javax.mail.MessagingException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowException;
import org.dspace.xmlworkflow.XmlWorkflowManager;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class WorkflowTools {
    public boolean isItemInWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            if (ConfigurationManager.getProperty((String)"workflow", (String)"workflow.framework").equals("xmlworkflow")) {
                return XmlWorkflowItem.findByItem((Context)context, (Item)item) != null;
            }
            return WorkflowItem.findByItem((Context)context, (Item)item) != null;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public boolean isItemInWorkspace(Context context, Item item) throws DSpaceSwordException {
        try {
            return WorkspaceItem.findByItem((Context)context, (Item)item) != null;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public InProgressSubmission getWorkflowItem(Context context, Item item) throws DSpaceSwordException {
        try {
            if (ConfigurationManager.getProperty((String)"workflow", (String)"workflow.framework").equals("xmlworkflow")) {
                return XmlWorkflowItem.findByItem((Context)context, (Item)item);
            }
            return WorkflowItem.findByItem((Context)context, (Item)item);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public WorkspaceItem getWorkspaceItem(Context context, Item item) throws DSpaceSwordException {
        try {
            return WorkspaceItem.findByItem((Context)context, (Item)item);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public void startWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            WorkspaceItem wsi = this.getWorkspaceItem(context, item);
            boolean notify = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"workflow.notify");
            if (ConfigurationManager.getProperty((String)"workflow", (String)"workflow.framework").equals("xmlworkflow")) {
                if (notify) {
                    XmlWorkflowManager.start((Context)context, (WorkspaceItem)wsi);
                } else {
                    XmlWorkflowManager.startWithoutNotify((Context)context, (WorkspaceItem)wsi);
                }
            } else if (notify) {
                WorkflowManager.start((Context)context, (WorkspaceItem)wsi);
            } else {
                WorkflowManager.startWithoutNotify((Context)context, (WorkspaceItem)wsi);
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (WorkflowException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (WorkflowConfigurationException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public void stopWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            InProgressSubmission wfi = this.getWorkflowItem(context, item);
            if (wfi != null) {
                if (wfi instanceof WorkflowItem) {
                    WorkflowManager.abort((Context)context, (WorkflowItem)((WorkflowItem)wfi), (EPerson)context.getCurrentUser());
                } else {
                    XmlWorkflowManager.abort((Context)context, (XmlWorkflowItem)((XmlWorkflowItem)wfi), (EPerson)context.getCurrentUser());
                }
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }
}

