/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Element;
import org.swordapp.server.UriRegistry;

public class SwordCollection {
    private Collection collection;
    private List<String> multipartAccept = new ArrayList();
    private Abdera abdera;
    private String collectionPolicy = null;
    private boolean mediation = false;
    private String treatment = null;
    private List<String> acceptPackaging = new ArrayList();
    private List<IRI> subServices = new ArrayList();
    private String dcAbstract = null;

    public SwordCollection() {
        this.abdera = new Abdera();
        this.collection = this.abdera.getFactory().newCollection();
    }

    public Collection getWrappedCollection() {
        return this.collection;
    }

    public Collection getAbderaCollection() {
        Collection abderaCollection = (Collection)this.collection.clone();
        for (String mpa : this.multipartAccept) {
            Element element = this.abdera.getFactory().newElement(UriRegistry.APP_ACCEPT);
            element.setAttributeValue("alternate", "multipart-related");
            element.setText(mpa);
            abderaCollection.addExtension(element);
        }
        if (this.collectionPolicy != null) {
            abderaCollection.addSimpleExtension(UriRegistry.SWORD_COLLECTION_POLICY, this.collectionPolicy);
        }
        abderaCollection.addSimpleExtension(UriRegistry.SWORD_MEDIATION, this.mediation ? "true" : "false");
        if (this.treatment != null) {
            abderaCollection.addSimpleExtension(UriRegistry.SWORD_TREATMENT, this.treatment);
        }
        for (String ap : this.acceptPackaging) {
            abderaCollection.addSimpleExtension(UriRegistry.SWORD_ACCEPT_PACKAGING, ap);
        }
        for (IRI ss : this.subServices) {
            abderaCollection.addSimpleExtension(UriRegistry.SWORD_SERVICE, ss.toString());
        }
        if (this.dcAbstract != null) {
            abderaCollection.addSimpleExtension(UriRegistry.DC_ABSTRACT, this.dcAbstract);
        }
        return abderaCollection;
    }

    public void setLocation(String href) {
        this.collection.setHref(href);
    }

    public void setAbstract(String dcAbstract) {
        this.dcAbstract = dcAbstract;
    }

    public List<IRI> getSubServices() {
        return this.subServices;
    }

    public void setSubServices(List<IRI> subServices) {
        this.subServices = subServices;
    }

    public void addSubService(IRI subService) {
        this.subServices.add(subService);
    }

    public void setCollectionPolicy(String collectionPolicy) {
        this.collectionPolicy = collectionPolicy;
    }

    public void setMediation(boolean mediation) {
        this.mediation = mediation;
    }

    public void setTreatment(String treatment) {
        this.treatment = treatment;
    }

    public void setAcceptPackaging(List<String> acceptPackaging) {
        this.acceptPackaging = acceptPackaging;
    }

    public void addAcceptPackaging(String acceptPackaging) {
        this.acceptPackaging.add(acceptPackaging);
    }

    public String getCollectionPolicy() {
        return this.collectionPolicy;
    }

    public boolean isMediation() {
        return this.mediation;
    }

    public String getTreatment() {
        return this.treatment;
    }

    public List<String> getAcceptPackaging() {
        return this.acceptPackaging;
    }

    public void setTitle(String title) {
        this.collection.setTitle(title);
    }

    public void setHref(String href) {
        this.collection.setHref(href);
    }

    public void setAccept(String ... mediaRanges) {
        this.collection.setAccept(mediaRanges);
    }

    public void setAcceptsEntry() {
        this.collection.setAcceptsEntry();
    }

    public void setAcceptsNothing() {
        this.collection.setAcceptsNothing();
    }

    public void addAccepts(String mediaRange) {
        this.collection.addAccepts(mediaRange);
    }

    public void addAccepts(String ... mediaRanges) {
        this.collection.addAccepts(mediaRanges);
    }

    public void addAcceptsEntry() {
        this.collection.addAcceptsEntry();
    }

    public void setMultipartAccept(String ... mediaRanges) {
        List<String> mrs = Arrays.asList(mediaRanges);
        this.multipartAccept.clear();
        this.multipartAccept.addAll(mrs);
    }

    public void addMultipartAccepts(String mediaRange) {
        this.multipartAccept.add(mediaRange);
    }

    public void addMultipartAccepts(String ... mediaRanges) {
        List<String> mrs = Arrays.asList(mediaRanges);
        this.multipartAccept.addAll(mrs);
    }

    public List<String> getMultipartAccept() {
        ArrayList<String> accepts = new ArrayList<String>();
        List elements = this.collection.getElements();
        boolean noAccept = false;
        for (Element e : elements) {
            String multipartRelated = e.getAttributeValue("alternate");
            QName qn = e.getQName();
            if (!qn.getLocalPart().equals("accept") || !qn.getNamespaceURI().equals(UriRegistry.APP_NAMESPACE) || !"multipart-related".equals(multipartRelated)) continue;
            String content = e.getText();
            if (content == null || "".equals(content)) {
                noAccept = true;
            }
            if (content == null || "".equals(content) || accepts.contains(content)) continue;
            accepts.add(content);
        }
        if (accepts.size() == 0 && !noAccept) {
            accepts.add("application/atom+xml;type=entry");
        }
        return this.rationaliseAccepts(accepts);
    }

    public List<String> getSinglepartAccept() {
        ArrayList<String> accepts = new ArrayList<String>();
        List elements = this.collection.getElements();
        boolean noAccept = false;
        for (Element e : elements) {
            String multipartRelated = e.getAttributeValue("alternate");
            QName qn = e.getQName();
            if (!qn.getLocalPart().equals("accept") || !qn.getNamespaceURI().equals(UriRegistry.APP_NAMESPACE) || "multipart-related".equals(multipartRelated)) continue;
            String content = e.getText();
            if (content == null || "".equals(content)) {
                noAccept = true;
            }
            if (content == null || "".equals(content) || accepts.contains(content)) continue;
            accepts.add(content);
        }
        if (accepts.size() == 0 && !noAccept) {
            accepts.add("application/atom+xml;type=entry");
        }
        return this.rationaliseAccepts(accepts);
    }

    private List<String> rationaliseAccepts(List<String> accepts) {
        ArrayList<String> rational = new ArrayList<String>();
        if (accepts.contains("*/*")) {
            rational.add("*/*");
            return rational;
        }
        ArrayList<String> wildcards = new ArrayList<String>();
        for (String a : accepts) {
            if (!a.contains("/*")) continue;
            String wild = a.substring(0, a.indexOf("/"));
            wildcards.add(wild);
            if (rational.contains(a)) continue;
            rational.add(a);
        }
        for (String a : accepts) {
            String type = a.substring(0, a.indexOf("/"));
            if (wildcards.contains(type)) continue;
            rational.add(a);
        }
        return rational;
    }
}

