/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.SwordDisseminatorFactory;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;

public class SwordConfigurationDSpace
implements SwordConfiguration {
    public static final Logger log = Logger.getLogger(SwordConfigurationDSpace.class);
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private boolean verbose = true;
    private int maxUploadSize = -1;
    private boolean mediated = false;
    private boolean keepOriginal = false;
    private String swordBundle = "SWORD";
    private boolean keepPackageOnFailedIngest = false;
    private String failedPackageDir = null;
    private boolean allowCommunityDeposit = false;
    private boolean entryFirst = false;
    private List<String> swordaccepts;

    public SwordConfigurationDSpace() {
        int mus = this.configurationService.getIntProperty("swordv2-server.max-upload-size");
        if (mus > 0) {
            this.maxUploadSize = mus;
        }
        this.mediated = this.configurationService.getBooleanProperty("swordv2-server.on-behalf-of.enable", false);
        this.keepOriginal = this.configurationService.getBooleanProperty("swordv2-server.keep-original-package");
        String bundle = this.configurationService.getProperty("swordv2-server.bundle.name");
        if (StringUtils.isBlank((String)bundle)) {
            this.swordBundle = bundle;
        }
        this.keepPackageOnFailedIngest = this.configurationService.getBooleanProperty("swordv2-server.keep-package-on-fail", false);
        this.failedPackageDir = this.configurationService.getProperty("swordv2-server.failed-package.dir");
        Object[] acceptsFormats = this.configurationService.getArrayProperty("swordv2-server.accepts");
        this.swordaccepts = new ArrayList();
        if (ArrayUtils.isEmpty((Object[])acceptsFormats)) {
            acceptsFormats = new String[]{"application/zip"};
        }
        for (Object element : acceptsFormats) {
            this.swordaccepts.add(((String)element).trim());
        }
        this.allowCommunityDeposit = this.configurationService.getBooleanProperty("swordv2-server.allow-community-deposit");
        this.entryFirst = this.configurationService.getBooleanProperty("swordv2-server.multipart.entry-first", false);
    }

    public String getStringProperty(String propName, String defaultValue, String[] allowedValues) {
        String cfg = this.configurationService.getProperty(propName);
        if (StringUtils.isBlank((String)cfg)) {
            return defaultValue;
        }
        boolean allowed = false;
        if (allowedValues != null) {
            for (String value : allowedValues) {
                if (!cfg.equals(value)) continue;
                allowed = true;
            }
        } else {
            allowed = true;
        }
        if (allowed) {
            return cfg;
        }
        return defaultValue;
    }

    public String getStringProperty(String propName, String defaultValue) {
        return this.getStringProperty(propName, defaultValue, null);
    }

    public boolean returnDepositReceipt() {
        return true;
    }

    public boolean returnStackTraceInError() {
        return this.configurationService.getBooleanProperty("swordv2-server.verbose-description.error.enable");
    }

    public boolean returnErrorBody() {
        return true;
    }

    public String generator() {
        return this.getStringProperty("swordv2-server.generator.url", "http://www.dspace.org/ns/sword/2.0/");
    }

    public String generatorVersion() {
        return this.getStringProperty("swordv2-server.generator.version", "2.0");
    }

    public String administratorEmail() {
        return this.getStringProperty("mail.admin", null);
    }

    public String getAuthType() {
        return this.getStringProperty("swordv2-server.auth-type", "Basic", new String[]{"Basic", "None"});
    }

    public boolean storeAndCheckBinary() {
        return true;
    }

    public String getTempDirectory() {
        return this.getStringProperty("swordv2-server.upload.tempdir", null);
    }

    public String getAlternateUrl() {
        return this.configurationService.getProperty("swordv2-server.error.alternate.url");
    }

    public String getAlternateUrlContentType() {
        return this.configurationService.getProperty("swordv2-server.error.alternate.content-type");
    }

    public SwordUrlManager getUrlManager(Context context, SwordConfigurationDSpace config) {
        return new SwordUrlManager(config, context);
    }

    public List<String> getDisseminatePackaging() throws DSpaceSwordException, SwordError {
        ArrayList<String> dps = new ArrayList<String>();
        List packagingFormats = this.configurationService.getPropertyKeys("swordv2-server.disseminate-packaging");
        for (String key : packagingFormats) {
            String value = this.configurationService.getProperty(key);
            boolean disseminable = true;
            try {
                SwordContentDisseminator swordContentDisseminator = SwordDisseminatorFactory.getContentInstance(null, (String)value);
            }
            catch (SwordError e) {
                disseminable = false;
            }
            if (!disseminable) continue;
            dps.add(value);
        }
        return dps;
    }

    public boolean isEntryFirst() {
        return this.entryFirst;
    }

    public boolean allowCommunityDeposit() {
        return this.allowCommunityDeposit;
    }

    public String getSwordBundle() {
        return this.swordBundle;
    }

    public void setSwordBundle(String swordBundle) {
        this.swordBundle = swordBundle;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public boolean isMediated() {
        return this.mediated;
    }

    public void setMediated(boolean mediated) {
        this.mediated = mediated;
    }

    public boolean isKeepOriginal() {
        return this.keepOriginal;
    }

    public void setKeepOriginal(boolean keepOriginal) {
        this.keepOriginal = keepOriginal;
    }

    public void setKeepPackageOnFailedIngest(boolean keepOriginalOnFail) {
        this.keepPackageOnFailedIngest = keepOriginalOnFail;
    }

    public boolean isKeepPackageOnFailedIngest() {
        return this.keepPackageOnFailedIngest;
    }

    public void setFailedPackageDir(String dir) {
        this.failedPackageDir = dir;
    }

    public String getFailedPackageDir() {
        return this.failedPackageDir;
    }

    public List<String> getAccepts(Context context, DSpaceObject dso) throws DSpaceSwordException {
        try {
            ArrayList<String> accepts = new ArrayList<String>();
            if (dso instanceof Collection) {
                for (String format : this.swordaccepts) {
                    accepts.add(format);
                }
            } else if (dso instanceof Item) {
                List bfs = this.bitstreamFormatService.findNonInternal(context);
                for (BitstreamFormat bf : bfs) {
                    accepts.add(bf.getMIMEType());
                }
                for (String format : this.swordaccepts) {
                    if (accepts.contains(format)) continue;
                    accepts.add(format);
                }
            }
            return accepts;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public List<String> getCollectionAccepts() throws DSpaceSwordException {
        ArrayList<String> accepts = new ArrayList<String>();
        for (String format : this.swordaccepts) {
            accepts.add(format);
        }
        return accepts;
    }

    public List<String> getAcceptPackaging(Collection col) {
        String handle = col.getHandle();
        ArrayList<String> aps = new ArrayList<String>();
        String acceptPackagingPrefix = "swordv2-server.accept-packaging.collection";
        List acceptFormats = this.configurationService.getPropertyKeys(acceptPackagingPrefix);
        for (String key : acceptFormats) {
            String suffix = key.substring(acceptPackagingPrefix.length() + 1);
            boolean withHandle = false;
            if (suffix.startsWith(handle)) {
                withHandle = true;
            }
            boolean general = false;
            if (suffix.indexOf(".") == -1) {
                general = true;
            }
            if (!withHandle && !general) continue;
            String value = this.configurationService.getProperty(key);
            aps.add(value);
        }
        return aps;
    }

    public List<String> getItemAcceptPackaging() {
        ArrayList<String> aps = new ArrayList<String>();
        String acceptPackagingPrefix = "swordv2-server.accept-packaging.item";
        List acceptFormats = this.configurationService.getPropertyKeys(acceptPackagingPrefix);
        for (String key : acceptFormats) {
            String value = this.configurationService.getProperty(key);
            aps.add(value);
        }
        return aps;
    }

    public boolean isAcceptedPackaging(String packageFormat, DSpaceObject dso) throws DSpaceSwordException, SwordError {
        block4: {
            block3: {
                if (packageFormat == null || "".equals(packageFormat)) {
                    return true;
                }
                if (!(dso instanceof Collection)) break block3;
                List accepts = this.getAcceptPackaging((Collection)dso);
                for (String accept : accepts) {
                    if (!accept.equals(packageFormat)) continue;
                    return true;
                }
                break block4;
            }
            if (!(dso instanceof Item)) break block4;
            List accepts = this.getItemAcceptPackaging();
            for (String accept : accepts) {
                if (!accept.equals(packageFormat)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAcceptableContentType(Context context, String type, DSpaceObject dso) throws DSpaceSwordException {
        List accepts = this.getAccepts(context, dso);
        for (String acc : accepts) {
            if (!this.contentTypeMatches(type, acc)) continue;
            return true;
        }
        return accepts.contains(type);
    }

    private boolean contentTypeMatches(String type, String pattern) {
        if ("*/*".equals(pattern.trim())) {
            return true;
        }
        String[] bits = pattern.trim().split("/");
        String prefixPattern = bits.length > 0 ? bits[0] : "*";
        String suffixPattern = bits.length > 1 ? bits[1] : "*";
        String[] tbits = type.trim().split("/");
        String typePrefix = tbits.length > 0 ? tbits[0] : "*";
        String typeSuffix = tbits.length > 1 ? tbits[1] : "*";
        boolean prefixMatch = false;
        boolean suffixMatch = false;
        if ("*".equals(prefixPattern) || prefixPattern.equals(typePrefix)) {
            prefixMatch = true;
        }
        if ("*".equals(suffixPattern) || suffixPattern.equals(typeSuffix)) {
            suffixMatch = true;
        }
        return prefixMatch && suffixMatch;
    }

    public String getStateUri(String state) {
        return this.configurationService.getProperty("swordv2-server.state." + state + ".uri");
    }

    public String getStateDescription(String state) {
        return this.configurationService.getProperty("swordv2-server.state." + state + ".description");
    }

    public boolean allowUnauthenticatedMediaAccess() {
        return false;
    }
}

