/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.AtomCollectionGenerator;
import org.dspace.sword2.CommunityCollectionGenerator;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordCollection;

public class CollectionCollectionGenerator
implements AtomCollectionGenerator {
    private static Logger log = Logger.getLogger(CommunityCollectionGenerator.class);
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    public SwordCollection buildCollection(Context context, DSpaceObject dso, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException {
        String firstValue;
        if (!(dso instanceof Collection)) {
            log.error((Object)"buildCollection passed argument which is not of type Collection");
            throw new DSpaceSwordException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SwordUrlManager urlManager = swordConfig.getUrlManager(context, swordConfig);
        Collection col = (Collection)dso;
        SwordCollection scol = new SwordCollection();
        String location = urlManager.getDepositLocation(col);
        String title = this.collectionService.getName((DSpaceObject)col);
        String collectionPolicy = this.collectionService.getLicense(col);
        List dcAbstracts = this.collectionService.getMetadataByMetadataString((DSpaceObject)col, "short_description");
        boolean mediation = swordConfig.isMediated();
        scol.setLocation(location);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            scol.setTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionPolicy)) {
            scol.setCollectionPolicy(collectionPolicy);
        }
        if (dcAbstracts != null && !dcAbstracts.isEmpty() && StringUtils.isNotBlank((CharSequence)(firstValue = ((MetadataValue)dcAbstracts.get(0)).getValue()))) {
            scol.setAbstract(firstValue);
        }
        scol.setMediation(mediation);
        List accepts = swordConfig.getCollectionAccepts();
        for (String accept : accepts) {
            scol.addAccepts(accept);
            scol.addMultipartAccepts(accept);
        }
        List aps = swordConfig.getAcceptPackaging(col);
        for (String ap : aps) {
            scol.addAcceptPackaging(ap);
        }
        boolean itemService = ConfigurationManager.getBooleanProperty((String)"sword.expose-items");
        if (itemService) {
            String subService = urlManager.constructSubServiceUrl(col);
            scol.addSubService(new IRI(subService));
        }
        log.debug((Object)"Created ATOM Collection for DSpace Collection");
        return scol;
    }
}

