/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sword2.ContainerManagerDSpace;
import org.dspace.sword2.DSpaceSwordAPI;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.ReceiptGenerator;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.SwordContentIngester;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.SwordDisseminatorFactory;
import org.dspace.sword2.SwordIngesterFactory;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.sword2.VerboseDescription;
import org.dspace.sword2.VersionManager;
import org.dspace.sword2.WorkflowManager;
import org.dspace.sword2.WorkflowManagerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.MediaResource;
import org.swordapp.server.MediaResourceManager;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class MediaResourceManagerDSpace
extends DSpaceSwordAPI
implements MediaResourceManager {
    private static Logger log = Logger.getLogger(MediaResourceManagerDSpace.class);
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private VerboseDescription verboseDescription = new VerboseDescription();

    private boolean isAccessible(Context context, Bitstream bitstream) throws DSpaceSwordException {
        try {
            return this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)bitstream, 0);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private boolean isAccessible(Context context, Item item) throws DSpaceSwordException {
        try {
            return this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 0);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private MediaResource getBitstreamResource(Context context, Bitstream bitstream) throws SwordServerException, SwordAuthException {
        try {
            InputStream stream = this.bitstreamService.retrieve(context, bitstream);
            MediaResource mr = new MediaResource(stream, bitstream.getFormat(context).getMIMEType(), null, true);
            mr.setContentMD5(bitstream.getChecksum());
            mr.setLastModified(this.getLastModified(context, bitstream));
            return mr;
        }
        catch (IOException | SQLException e) {
            throw new SwordServerException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
    }

    private MediaResource getItemResource(Context context, Item item, SwordUrlManager urlManager, String uri, Map<String, String> accept) throws SwordError, DSpaceSwordException, SwordServerException {
        boolean feedRequest = urlManager.isFeedRequest(context, uri);
        SwordContentDisseminator disseminator = null;
        if (!feedRequest) {
            String acceptContentType = this.getHeader(accept, "Accept", null);
            String acceptPackaging = this.getHeader(accept, "Accept-Packaging", UriRegistry.PACKAGE_SIMPLE_ZIP);
            TreeMap analysed = this.analyseAccept(acceptContentType);
            disseminator = SwordDisseminatorFactory.getContentInstance((Map)analysed, (String)acceptPackaging);
        } else {
            HashMap analysed = new HashMap();
            ArrayList<String> list = new ArrayList<String>();
            list.add("application/atom+xml");
            analysed.put(Float.valueOf(1.0f), list);
            disseminator = SwordDisseminatorFactory.getContentInstance(analysed, null);
        }
        InputStream stream = disseminator.disseminate(context, item);
        return new MediaResource(stream, disseminator.getContentType(), disseminator.getPackaging());
    }

    public MediaResource getMediaResourceRepresentation(String uri, Map<String, String> accept, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        Context ctx = null;
        try {
            ctx = new Context();
            SwordUrlManager urlManager = config.getUrlManager(ctx, config);
            if (urlManager.isActionableBitstreamUrl(ctx, uri)) {
                Bitstream bitstream = urlManager.getBitstream(ctx, uri);
                if (bitstream == null) {
                    throw new SwordError(404);
                }
                WorkflowManagerFactory.getInstance().retrieveBitstream(ctx, bitstream);
                boolean accessible = this.isAccessible(ctx, bitstream);
                if (!accessible) {
                    sc = this.doAuth(authCredentials);
                    ctx.abort();
                    ctx = sc.getContext();
                    bitstream = (Bitstream)this.bitstreamService.find(ctx, bitstream.getID());
                    accessible = this.isAccessible(ctx, bitstream);
                    if (!accessible) {
                        throw new SwordAuthException();
                    }
                }
                MediaResource mr = this.getBitstreamResource(ctx, bitstream);
                if (sc != null) {
                    sc.abort();
                }
                if (ctx.isValid()) {
                    ctx.abort();
                }
                MediaResource mediaResource = mr;
                return mediaResource;
            }
            Item item = urlManager.getItem(ctx, uri);
            if (item == null) {
                throw new SwordError(404);
            }
            WorkflowManagerFactory.getInstance().retrieveContent(ctx, item);
            boolean accessible = this.isAccessible(ctx, item);
            if (!accessible) {
                sc = this.doAuth(authCredentials);
                ctx.abort();
                ctx = sc.getContext();
            }
            MediaResource mr = this.getItemResource(ctx, item, urlManager, uri, accept);
            ctx.abort();
            MediaResource mediaResource = mr;
            return mediaResource;
        }
        catch (SQLException | DSpaceSwordException e) {
            throw new SwordServerException(e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
            if (ctx != null && ctx.isValid()) {
                ctx.abort();
            }
        }
    }

    private Date getLastModified(Context context, Bitstream bitstream) throws SQLException {
        Date lm = null;
        List bundles = bitstream.getBundles();
        for (Bundle bundle : bundles) {
            List items = bundle.getItems();
            for (Item item : items) {
                Date possible = item.getLastModified();
                if (lm == null) {
                    lm = possible;
                    continue;
                }
                if (possible.getTime() <= lm.getTime()) continue;
                lm = possible;
            }
        }
        if (lm == null) {
            return new Date();
        }
        return lm;
    }

    public DepositReceipt replaceMediaResource(String emUri, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose replace of media resource");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            DepositReceipt receipt;
            WorkflowManager wfm;
            SwordUrlManager urlManager;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_replace", (String)""));
            }
            if ((urlManager = config.getUrlManager(context, config)).isActionableBitstreamUrl(context, emUri)) {
                Bitstream bitstream = urlManager.getBitstream(context, emUri);
                if (bitstream == null) {
                    throw new SwordError(404);
                }
                wfm = WorkflowManagerFactory.getInstance();
                wfm.replaceBitstream(context, bitstream);
                ArrayList<Item> items = new ArrayList<Item>();
                List bundles = bitstream.getBundles();
                for (Bundle bundle : bundles) {
                    List bundleItems = bundle.getItems();
                    for (Item item : bundleItems) {
                        this.checkAuth(sc, item);
                        items.add(item);
                    }
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                DepositResult result = null;
                try {
                    result = this.replaceBitstream(sc, items, bitstream, deposit, authCredentials, config);
                }
                catch (DSpaceSwordException | SwordError e) {
                    if (config.isKeepPackageOnFailedIngest()) {
                        try {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        }
                        catch (IOException e2) {
                            log.warn((Object)("Unable to store SWORD package as file: " + e));
                        }
                    }
                    throw e;
                }
                wfm.resolveState(context, deposit, null, this.verboseDescription, false);
                ReceiptGenerator genny = new ReceiptGenerator();
                receipt = genny.createFileReceipt(context, result, config);
            } else {
                Item item = this.getDSpaceTarget(context, emUri, config);
                if (item == null) {
                    throw new SwordError(404);
                }
                wfm = WorkflowManagerFactory.getInstance();
                wfm.replaceResourceContent(context, item);
                SwordAuthenticator auth = new SwordAuthenticator();
                if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                    String oboEmail = "none";
                    if (sc.getOnBehalfOf() != null) {
                        oboEmail = sc.getOnBehalfOf().getEmail();
                    }
                    log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                    throw new SwordAuthException("Cannot replace the given item with this context");
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                try {
                    this.replaceContent(sc, item, deposit, authCredentials, config);
                }
                catch (DSpaceSwordException | SwordError e) {
                    if (config.isKeepPackageOnFailedIngest()) {
                        try {
                            this.storePackageAsFile(deposit, authCredentials, config);
                        }
                        catch (IOException e2) {
                            log.warn((Object)("Unable to store SWORD package as file: " + e));
                        }
                    }
                    throw e;
                }
                wfm.resolveState(context, deposit, null, this.verboseDescription, false);
                ReceiptGenerator genny = new ReceiptGenerator();
                receipt = genny.createMediaResourceReceipt(context, item, config);
            }
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        catch (SQLException e) {
            throw new SwordServerException((Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public void deleteMediaResource(String emUri, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose delete of media resource");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_delete", (String)""));
            }
            SwordUrlManager urlManager = config.getUrlManager(context, config);
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            if (urlManager.isActionableBitstreamUrl(context, emUri)) {
                Bitstream bitstream = urlManager.getBitstream(context, emUri);
                if (bitstream == null) {
                    throw new SwordError(404);
                }
                wfm.deleteBitstream(context, bitstream);
                ArrayList<Item> items = new ArrayList<Item>();
                for (Bundle bundle : bitstream.getBundles()) {
                    List bundleItems = bundle.getItems();
                    for (Item item : bundleItems) {
                        this.checkAuth(sc, item);
                        items.add(item);
                    }
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                this.removeBitstream(sc, bitstream, items, authCredentials, config);
            } else {
                Item item = this.getDSpaceTarget(context, emUri, config);
                if (item == null) {
                    throw new SwordError(404);
                }
                wfm.deleteMediaResource(context, item);
                SwordAuthenticator auth = new SwordAuthenticator();
                if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                    String oboEmail = "none";
                    if (sc.getOnBehalfOf() != null) {
                        oboEmail = sc.getOnBehalfOf().getEmail();
                    }
                    log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                    throw new SwordAuthException("Cannot replace the given item with this context");
                }
                this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
                if (sc.getOnBehalfOf() != null) {
                    this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
                }
                this.removeContent(sc, item, authCredentials, config);
            }
            wfm.resolveState(context, null, null, this.verboseDescription, false);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            sc.commit();
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        catch (SQLException e) {
            throw new SwordServerException((Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt addResource(String emUri, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose add to media resource");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            DepositResult result;
            Item item;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_add", (String)""));
            }
            if ((item = this.getDSpaceTarget(context, emUri, config)) == null) {
                throw new SwordError(404);
            }
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.addResourceContent(context, item);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot replace the given item with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            try {
                result = this.addContent(sc, item, deposit, authCredentials, config);
                if (deposit.isMultipart()) {
                    ContainerManagerDSpace cm = new ContainerManagerDSpace();
                    result = cm.doAddMetadata(sc, item, deposit, authCredentials, config, result);
                }
            }
            catch (DSpaceSwordException | SwordError e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storePackageAsFile(deposit, authCredentials, config);
                        if (deposit.isMultipart()) {
                            this.storeEntryAsFile(deposit, authCredentials, config);
                        }
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD package as file: " + e));
                    }
                }
                throw e;
            }
            wfm.resolveState(context, deposit, null, this.verboseDescription, false);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = deposit.getPackaging().equals(UriRegistry.PACKAGE_BINARY) ? genny.createFileReceipt(context, result, config) : genny.createReceipt(context, result, config, true);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for add processing: " + delta + " ms");
            this.addVerboseDescription(receipt, this.verboseDescription);
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    private void removeContent(SwordContext swordContext, Item item, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordAuthException {
        try {
            VersionManager vm = new VersionManager();
            Iterator bundles = item.getBundles().iterator();
            while (bundles.hasNext()) {
                Bundle bundle = (Bundle)bundles.next();
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                bundles.remove();
                vm.removeBundle(swordContext.getContext(), item, bundle);
            }
        }
        catch (IOException | SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
    }

    private void removeBitstream(SwordContext swordContext, Bitstream bitstream, List<Item> items, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordAuthException {
        try {
            VersionManager vm = new VersionManager();
            for (Item item : items) {
                vm.removeBitstream(swordContext.getContext(), item, bitstream);
            }
        }
        catch (IOException | SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
    }

    private void replaceContent(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)item);
        SwordContentIngester si = SwordIngesterFactory.getContentInstance((Context)context, (Deposit)deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        try {
            VersionManager vm = new VersionManager();
            vm.removeBundle(swordContext.getContext(), item, "ORIGINAL");
        }
        catch (IOException | SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        DepositResult result = si.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription);
        this.verboseDescription.append("Replace completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
    }

    private DepositResult replaceBitstream(SwordContext swordContext, List<Item> items, Bitstream bitstream, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        for (Item item : items) {
            this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)item);
        }
        SwordContentIngester si = SwordIngesterFactory.getContentInstance((Context)context, (Deposit)deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        try {
            this.removeBitstream(swordContext, bitstream, items, authCredentials, swordConfig);
            DepositResult result = null;
            boolean first = true;
            for (Item item : items) {
                if (first) {
                    result = this.addContent(swordContext, item, deposit, authCredentials, swordConfig);
                    continue;
                }
                List bundles = item.getBundles();
                if (!bundles.isEmpty()) {
                    this.bundleService.addBitstream(context, (Bundle)bundles.get(0), result.getOriginalDeposit());
                    continue;
                }
                Bundle bundle = this.bundleService.create(context, item, "ORIGINAL");
                this.bundleService.addBitstream(context, bundle, result.getOriginalDeposit());
            }
            this.verboseDescription.append("Replace completed successfully");
            return result;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
    }

    private DepositResult addContent(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)item);
        SwordContentIngester si = SwordIngesterFactory.getContentInstance((Context)context, (Deposit)deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        DepositResult result = si.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription);
        this.verboseDescription.append("Add completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    private Item getDSpaceTarget(Context context, String editMediaUrl, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        Item item = urlManager.getItem(context, editMediaUrl);
        this.verboseDescription.append("Performing replace using edit-media URL: " + editMediaUrl);
        this.verboseDescription.append("Location resolves to item with handle: " + item.getHandle());
        return item;
    }

    private void checkAuth(SwordContext sc, Item item) throws DSpaceSwordException, SwordError, SwordAuthException {
        Context context = sc.getContext();
        SwordAuthenticator auth = new SwordAuthenticator();
        if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
            String oboEmail = "none";
            if (sc.getOnBehalfOf() != null) {
                oboEmail = sc.getOnBehalfOf().getEmail();
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
            throw new SwordAuthException("Cannot replace the given item with this context");
        }
    }
}

