/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.builder;

import com.lyncode.builder.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.xoai.dataprovider.exceptions.BadArgumentException;
import org.dspace.xoai.dataprovider.exceptions.DuplicateDefinitionException;
import org.dspace.xoai.dataprovider.exceptions.IllegalVerbException;
import org.dspace.xoai.dataprovider.exceptions.UnknownParameterException;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.dataprovider.parameters.OAIRequest;
import org.dspace.xoai.exceptions.InvalidResumptionTokenException;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.services.impl.UTCDateProvider;

public class OAIRequestParametersBuilder
implements Builder<OAIRequest> {
    private final UTCDateProvider utcDateProvider = new UTCDateProvider();
    private Map<String, List<String>> params = new HashMap<String, List<String>>();

    public OAIRequestParametersBuilder with(String name, String ... values) {
        if (values == null || values.length > 0 && values[0] == null) {
            return this.without(name);
        }
        if (!this.params.containsKey(name)) {
            this.params.put(name, new ArrayList());
        }
        this.params.get(name).addAll(Arrays.asList(values));
        return this;
    }

    public OAIRequest build() {
        return new OAIRequest(this.params);
    }

    public OAIRequestParametersBuilder withVerb(String verb) {
        return this.with("verb", verb);
    }

    public OAIRequestParametersBuilder withVerb(Verb.Type verb) {
        return this.with("verb", verb.displayName());
    }

    public OAIRequestParametersBuilder withMetadataPrefix(String mdp) {
        return this.with("metadataPrefix", mdp);
    }

    public OAIRequestParametersBuilder withFrom(Date date) {
        if (date != null) {
            return this.with("from", this.utcDateProvider.format(date));
        }
        return this.without("from");
    }

    private OAIRequestParametersBuilder without(String field) {
        this.params.remove(field);
        return this;
    }

    public OAIRequestParametersBuilder withUntil(Date date) {
        if (date != null) {
            return this.with("until", this.utcDateProvider.format(date));
        }
        return this.without("until");
    }

    public OAIRequestParametersBuilder withIdentifier(String identifier) {
        return this.with("identifier", identifier);
    }

    public OAIRequestParametersBuilder withResumptionToken(String resumptionToken) {
        return this.with("resumptionToken", resumptionToken);
    }

    public OAICompiledRequest compile() throws BadArgumentException, InvalidResumptionTokenException, UnknownParameterException, IllegalVerbException, DuplicateDefinitionException {
        return this.build().compile();
    }

    public OAIRequestParametersBuilder withSet(String set) {
        return this.with("set", set);
    }
}

