/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers;

import org.dspace.xoai.dataprovider.exceptions.BadArgumentException;
import org.dspace.xoai.dataprovider.exceptions.BadResumptionToken;
import org.dspace.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import org.dspace.xoai.dataprovider.exceptions.DoesNotSupportSetsException;
import org.dspace.xoai.dataprovider.exceptions.DuplicateDefinitionException;
import org.dspace.xoai.dataprovider.exceptions.HandlerException;
import org.dspace.xoai.dataprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.dataprovider.exceptions.IllegalVerbException;
import org.dspace.xoai.dataprovider.exceptions.NoMatchesException;
import org.dspace.xoai.dataprovider.exceptions.NoMetadataFormatsException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.exceptions.UnknownParameterException;
import org.dspace.xoai.model.oaipmh.Error;

public class ErrorHandler {
    public Error handle(HandlerException ex) throws OAIException {
        if (ex instanceof IllegalVerbException) {
            return new Error("Illegal verb").withCode(Error.Code.BAD_VERB);
        }
        if (ex instanceof DoesNotSupportSetsException) {
            return new Error("This repository does not support sets").withCode(Error.Code.NO_SET_HIERARCHY);
        }
        if (ex instanceof NoMatchesException) {
            return new Error("No matches for the query").withCode(Error.Code.NO_RECORDS_MATCH);
        }
        if (ex instanceof BadResumptionToken) {
            return new Error("The resumption token is invalid").withCode(Error.Code.BAD_RESUMPTION_TOKEN);
        }
        if (ex instanceof IdDoesNotExistException) {
            return new Error("The given id does not exist").withCode(Error.Code.ID_DOES_NOT_EXIST);
        }
        if (ex instanceof NoMetadataFormatsException) {
            return new Error("The item does not have any metadata format available for dissemination").withCode(Error.Code.NO_METADATA_FORMATS);
        }
        if (ex instanceof BadArgumentException) {
            return new Error(ex.getMessage()).withCode(Error.Code.BAD_ARGUMENT);
        }
        if (ex instanceof CannotDisseminateFormatException) {
            return new Error("Cannot disseminate item with the given format").withCode(Error.Code.CANNOT_DISSEMINATE_FORMAT);
        }
        if (ex instanceof DuplicateDefinitionException) {
            return new Error(ex.getMessage()).withCode(Error.Code.BAD_ARGUMENT);
        }
        if (ex instanceof UnknownParameterException) {
            return new Error(ex.getMessage()).withCode(Error.Code.BAD_ARGUMENT);
        }
        return new Error(ex.getMessage()).withCode(Error.Code.BAD_ARGUMENT);
    }
}

