/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.dspace.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import org.dspace.xoai.dataprovider.exceptions.HandlerException;
import org.dspace.xoai.dataprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.handlers.VerbHandler;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.Item;
import org.dspace.xoai.dataprovider.model.MetadataFormat;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.dataprovider.repository.Repository;
import org.dspace.xoai.model.oaipmh.About;
import org.dspace.xoai.model.oaipmh.GetRecord;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.model.oaipmh.Metadata;
import org.dspace.xoai.model.oaipmh.Record;
import org.dspace.xoai.xml.XSLPipeline;
import org.dspace.xoai.xml.XmlWriter;

public class GetRecordHandler
extends VerbHandler<GetRecord> {
    public GetRecordHandler(Context context, Repository repository) {
        super(context, repository);
    }

    @Override
    public GetRecord handle(OAICompiledRequest parameters) throws OAIException, HandlerException {
        Header header = new Header();
        Record record = new Record().withHeader(header);
        GetRecord result = new GetRecord(record);
        MetadataFormat format = this.getContext().formatForPrefix(parameters.getMetadataPrefix());
        if (format == null) {
            throw new CannotDisseminateFormatException("Format " + parameters.getMetadataPrefix() + " not applicable to this item");
        }
        Item item = this.getRepository().getItemRepository().getItem(parameters.getIdentifier());
        if (this.getContext().hasCondition() && !this.getContext().getCondition().getFilter(this.getRepository().getFilterResolver()).isItemShown(item)) {
            throw new IdDoesNotExistException("This context does not include this item");
        }
        if (format.hasCondition() && !format.getCondition().getFilter(this.getRepository().getFilterResolver()).isItemShown(item)) {
            throw new CannotDisseminateFormatException("Format " + parameters.getMetadataPrefix() + " not applicable to this item");
        }
        header.withIdentifier(item.getIdentifier());
        header.withDatestamp(item.getDatestamp());
        for (Set set : this.getContext().getSets()) {
            if (!set.getCondition().getFilter(this.getRepository().getFilterResolver()).isItemShown(item)) continue;
            header.withSetSpec(set.getSpec());
        }
        for (Set set : item.getSets()) {
            header.withSetSpec(set.getSpec());
        }
        if (item.isDeleted()) {
            header.withStatus(Header.Status.DELETED);
        }
        if (!item.isDeleted()) {
            Metadata metadata = null;
            try {
                metadata = this.getContext().hasTransformer() ? new Metadata(this.toPipeline(item).apply(this.getContext().getTransformer()).apply(format.getTransformer()).process()) : new Metadata(this.toPipeline(item).apply(format.getTransformer()).process());
            }
            catch (XMLStreamException e) {
                throw new OAIException(e);
            }
            catch (TransformerException e) {
                throw new OAIException(e);
            }
            catch (IOException e) {
                throw new OAIException(e);
            }
            catch (XmlWriteException e) {
                throw new OAIException((Exception)((Object)e));
            }
            record.withMetadata(metadata);
            if (item.getAbout() != null) {
                for (About about : item.getAbout()) {
                    record.withAbout(about);
                }
            }
        }
        return result;
    }

    private XSLPipeline toPipeline(Item item) throws XmlWriteException, XMLStreamException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)output);
        Metadata metadata = item.getMetadata();
        metadata.write(writer);
        writer.close();
        return new XSLPipeline((InputStream)new ByteArrayInputStream(output.toByteArray()), true);
    }
}

