/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers;

import java.util.List;
import org.dspace.xoai.dataprovider.exceptions.BadArgumentException;
import org.dspace.xoai.dataprovider.exceptions.DoesNotSupportSetsException;
import org.dspace.xoai.dataprovider.exceptions.HandlerException;
import org.dspace.xoai.dataprovider.exceptions.InternalOAIException;
import org.dspace.xoai.dataprovider.exceptions.NoMatchesException;
import org.dspace.xoai.dataprovider.exceptions.NoMetadataFormatsException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.handlers.VerbHandler;
import org.dspace.xoai.dataprovider.handlers.helpers.ItemRepositoryHelper;
import org.dspace.xoai.dataprovider.handlers.helpers.PreconditionHelper;
import org.dspace.xoai.dataprovider.handlers.helpers.ResumptionTokenHelper;
import org.dspace.xoai.dataprovider.handlers.results.ListItemIdentifiersResult;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.ItemIdentifier;
import org.dspace.xoai.dataprovider.model.MetadataFormat;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.dataprovider.repository.Repository;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.model.oaipmh.ListIdentifiers;
import org.dspace.xoai.model.oaipmh.ResumptionToken;

public class ListIdentifiersHandler
extends VerbHandler<ListIdentifiers> {
    private final ItemRepositoryHelper itemRepositoryHelper;

    public ListIdentifiersHandler(Context context, Repository repository) {
        super(context, repository);
        this.itemRepositoryHelper = new ItemRepositoryHelper(repository.getItemRepository());
    }

    @Override
    public ListIdentifiers handle(OAICompiledRequest parameters) throws OAIException, HandlerException {
        ListItemIdentifiersResult listItemIdentifiersResult;
        ListIdentifiers result = new ListIdentifiers();
        if (parameters.hasSet() && !this.getRepository().getSetRepository().supportSets()) {
            throw new DoesNotSupportSetsException();
        }
        PreconditionHelper.checkMetadataFormat(this.getContext(), parameters.getMetadataPrefix());
        int length = this.getRepository().getConfiguration().getMaxListIdentifiers();
        int offset = this.getOffset(parameters);
        if (!parameters.hasSet()) {
            listItemIdentifiersResult = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiersUntil(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItemIdentifiers(this.getContext(), offset, length, parameters.getMetadataPrefix())));
        } else {
            if (!this.getRepository().getSetRepository().exists(parameters.getSet()) && !this.getContext().hasSet(parameters.getSet())) {
                throw new NoMatchesException();
            }
            listItemIdentifiersResult = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiersUntil(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItemIdentifiers(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet())));
        }
        List<ItemIdentifier> itemIdentifiers = listItemIdentifiersResult.getResults();
        if (itemIdentifiers.isEmpty()) {
            throw new NoMatchesException();
        }
        for (ItemIdentifier itemIdentifier : itemIdentifiers) {
            result.getHeaders().add(this.createHeader(parameters, itemIdentifier));
        }
        ResumptionToken.Value currentResumptionToken = new ResumptionToken.Value();
        if (parameters.hasResumptionToken()) {
            currentResumptionToken = parameters.getResumptionToken();
        } else if (listItemIdentifiersResult.hasMore()) {
            currentResumptionToken = parameters.extractResumptionToken();
        }
        ResumptionTokenHelper resumptionTokenHelper = new ResumptionTokenHelper(currentResumptionToken, this.getRepository().getConfiguration().getMaxListIdentifiers());
        result.withResumptionToken(resumptionTokenHelper.resolve(listItemIdentifiersResult.hasMore()));
        return result;
    }

    private int getOffset(OAICompiledRequest parameters) {
        if (!parameters.hasResumptionToken()) {
            return 0;
        }
        if (parameters.getResumptionToken().getOffset() == null) {
            return 0;
        }
        return parameters.getResumptionToken().getOffset().intValue();
    }

    private Header createHeader(OAICompiledRequest parameters, ItemIdentifier itemIdentifier) throws BadArgumentException, OAIException, NoMetadataFormatsException {
        MetadataFormat format = this.getContext().formatForPrefix(parameters.getMetadataPrefix());
        if (!itemIdentifier.isDeleted() && !this.canDisseminate(itemIdentifier, format)) {
            throw new InternalOAIException("The item repository is currently providing items which cannot be disseminated with format " + format.getPrefix());
        }
        Header header = new Header();
        header.withDatestamp(itemIdentifier.getDatestamp());
        header.withIdentifier(itemIdentifier.getIdentifier());
        if (itemIdentifier.isDeleted()) {
            header.withStatus(Header.Status.DELETED);
        }
        for (Set set : this.getContext().getSets()) {
            if (!set.getCondition().getFilter(this.getRepository().getFilterResolver()).isItemShown(itemIdentifier)) continue;
            header.withSetSpec(set.getSpec());
        }
        for (Set set : itemIdentifier.getSets()) {
            header.withSetSpec(set.getSpec());
        }
        return header;
    }

    private boolean canDisseminate(ItemIdentifier itemIdentifier, MetadataFormat format) {
        return !format.hasCondition() || format.getCondition().getFilter(this.getRepository().getFilterResolver()).isItemShown(itemIdentifier);
    }
}

