/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers;

import java.util.List;
import org.dspace.xoai.dataprovider.exceptions.HandlerException;
import org.dspace.xoai.dataprovider.exceptions.InternalOAIException;
import org.dspace.xoai.dataprovider.exceptions.NoMetadataFormatsException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.handlers.VerbHandler;
import org.dspace.xoai.dataprovider.handlers.helpers.ItemRepositoryHelper;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.Item;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.dataprovider.repository.Repository;
import org.dspace.xoai.model.oaipmh.ListMetadataFormats;
import org.dspace.xoai.model.oaipmh.MetadataFormat;

public class ListMetadataFormatsHandler
extends VerbHandler<ListMetadataFormats> {
    private ItemRepositoryHelper itemRepositoryHelper;

    public ListMetadataFormatsHandler(Context context, Repository repository) {
        super(context, repository);
        this.itemRepositoryHelper = new ItemRepositoryHelper(repository.getItemRepository());
        if (this.getContext().getMetadataFormats() == null || this.getContext().getMetadataFormats().isEmpty()) {
            throw new InternalOAIException("The context must expose at least one metadata format");
        }
    }

    @Override
    public ListMetadataFormats handle(OAICompiledRequest params) throws OAIException, HandlerException {
        ListMetadataFormats result = new ListMetadataFormats();
        if (params.hasIdentifier()) {
            Item item = this.itemRepositoryHelper.getItem(params.getIdentifier());
            List<org.dspace.xoai.dataprovider.model.MetadataFormat> metadataFormats = this.getContext().formatFor(this.getRepository().getFilterResolver(), item);
            if (metadataFormats.isEmpty()) {
                throw new NoMetadataFormatsException();
            }
            for (org.dspace.xoai.dataprovider.model.MetadataFormat metadataFormat : metadataFormats) {
                MetadataFormat format = new MetadataFormat().withMetadataPrefix(metadataFormat.getPrefix()).withMetadataNamespace(metadataFormat.getNamespace()).withSchema(metadataFormat.getSchemaLocation());
                result.withMetadataFormat(format);
            }
        } else {
            for (org.dspace.xoai.dataprovider.model.MetadataFormat metadataFormat : this.getContext().getMetadataFormats()) {
                MetadataFormat format = new MetadataFormat().withMetadataPrefix(metadataFormat.getPrefix()).withMetadataNamespace(metadataFormat.getNamespace()).withSchema(metadataFormat.getSchemaLocation());
                result.withMetadataFormat(format);
            }
        }
        return result;
    }
}

