/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.dspace.xoai.dataprovider.exceptions.BadArgumentException;
import org.dspace.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import org.dspace.xoai.dataprovider.exceptions.DoesNotSupportSetsException;
import org.dspace.xoai.dataprovider.exceptions.HandlerException;
import org.dspace.xoai.dataprovider.exceptions.NoMatchesException;
import org.dspace.xoai.dataprovider.exceptions.NoMetadataFormatsException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.handlers.VerbHandler;
import org.dspace.xoai.dataprovider.handlers.helpers.ItemHelper;
import org.dspace.xoai.dataprovider.handlers.helpers.ItemRepositoryHelper;
import org.dspace.xoai.dataprovider.handlers.helpers.PreconditionHelper;
import org.dspace.xoai.dataprovider.handlers.helpers.ResumptionTokenHelper;
import org.dspace.xoai.dataprovider.handlers.helpers.SetRepositoryHelper;
import org.dspace.xoai.dataprovider.handlers.results.ListItemsResults;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.Item;
import org.dspace.xoai.dataprovider.model.MetadataFormat;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.dataprovider.repository.Repository;
import org.dspace.xoai.model.oaipmh.About;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.model.oaipmh.ListRecords;
import org.dspace.xoai.model.oaipmh.Metadata;
import org.dspace.xoai.model.oaipmh.Record;
import org.dspace.xoai.model.oaipmh.ResumptionToken;
import org.dspace.xoai.xml.XSLPipeline;
import org.dspace.xoai.xml.XmlWriter;

public class ListRecordsHandler
extends VerbHandler<ListRecords> {
    private static Logger log = Logger.getLogger(ListRecordsHandler.class);
    private final ItemRepositoryHelper itemRepositoryHelper = new ItemRepositoryHelper(this.getRepository().getItemRepository());
    private final SetRepositoryHelper setRepositoryHelper = new SetRepositoryHelper(this.getRepository().getSetRepository());

    public ListRecordsHandler(Context context, Repository repository) {
        super(context, repository);
    }

    @Override
    public ListRecords handle(OAICompiledRequest parameters) throws OAIException, HandlerException {
        ListItemsResults result;
        ListRecords res = new ListRecords();
        int length = this.getRepository().getConfiguration().getMaxListRecords();
        if (parameters.hasSet() && !this.getRepository().getSetRepository().supportSets()) {
            throw new DoesNotSupportSetsException();
        }
        PreconditionHelper.checkMetadataFormat(this.getContext(), parameters.getMetadataPrefix());
        log.debug((Object)"Getting items from data source");
        int offset = this.getOffset(parameters);
        if (!parameters.hasSet()) {
            result = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemsUntil(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItems(this.getContext(), offset, length, parameters.getMetadataPrefix())));
        } else {
            if (!this.setRepositoryHelper.exists(this.getContext(), parameters.getSet())) {
                throw new NoMatchesException();
            }
            result = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemsUntil(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItems(this.getContext(), offset, length, parameters.getMetadataPrefix(), parameters.getSet())));
        }
        log.debug((Object)"Items retrieved from data source");
        List<Item> results = result.getResults();
        if (results.isEmpty()) {
            throw new NoMatchesException();
        }
        log.debug((Object)"Now adding records to the OAI-PMH Output");
        for (Item i : results) {
            res.withRecord(this.createRecord(parameters, i));
        }
        ResumptionToken.Value currentResumptionToken = new ResumptionToken.Value();
        if (parameters.hasResumptionToken()) {
            currentResumptionToken = parameters.getResumptionToken();
        } else if (result.hasMore()) {
            currentResumptionToken = parameters.extractResumptionToken();
        }
        ResumptionTokenHelper resumptionTokenHelper = new ResumptionTokenHelper(currentResumptionToken, this.getRepository().getConfiguration().getMaxListRecords());
        res.withResumptionToken(resumptionTokenHelper.resolve(result.hasMore()));
        return res;
    }

    private int getOffset(OAICompiledRequest parameters) {
        if (!parameters.hasResumptionToken()) {
            return 0;
        }
        if (parameters.getResumptionToken().getOffset() == null) {
            return 0;
        }
        return parameters.getResumptionToken().getOffset().intValue();
    }

    private Record createRecord(OAICompiledRequest parameters, Item item) throws BadArgumentException, OAIException, NoMetadataFormatsException, CannotDisseminateFormatException {
        MetadataFormat format = this.getContext().formatForPrefix(parameters.getMetadataPrefix());
        Header header = new Header();
        Record record = new Record().withHeader(header);
        header.withIdentifier(item.getIdentifier());
        ItemHelper itemHelperWrap = new ItemHelper(item);
        header.withDatestamp(item.getDatestamp());
        for (Set set : itemHelperWrap.getSets(this.getContext(), this.getRepository().getFilterResolver())) {
            header.withSetSpec(set.getSpec());
        }
        if (item.isDeleted()) {
            header.withStatus(Header.Status.DELETED);
        }
        if (!item.isDeleted()) {
            Metadata metadata = null;
            try {
                metadata = this.getContext().hasTransformer() ? new Metadata(this.toPipeline(item).apply(this.getContext().getTransformer()).apply(format.getTransformer()).process()) : new Metadata(this.toPipeline(item).apply(format.getTransformer()).process());
            }
            catch (XMLStreamException e) {
                throw new OAIException(e);
            }
            catch (TransformerException e) {
                throw new OAIException(e);
            }
            catch (IOException e) {
                throw new OAIException(e);
            }
            catch (XmlWriteException e) {
                throw new OAIException((Exception)((Object)e));
            }
            record.withMetadata(metadata);
            log.debug((Object)"Outputting ItemAbout");
            if (item.getAbout() != null) {
                for (About about : item.getAbout()) {
                    record.withAbout(about);
                }
            }
        }
        return record;
    }

    private XSLPipeline toPipeline(Item item) throws XmlWriteException, XMLStreamException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)output);
        Metadata metadata = item.getMetadata();
        metadata.write(writer);
        writer.close();
        return new XSLPipeline((InputStream)new ByteArrayInputStream(output.toByteArray()), true);
    }
}

