/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers;

import java.util.List;
import org.dspace.xoai.dataprovider.exceptions.DoesNotSupportSetsException;
import org.dspace.xoai.dataprovider.exceptions.HandlerException;
import org.dspace.xoai.dataprovider.exceptions.NoMatchesException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.handlers.VerbHandler;
import org.dspace.xoai.dataprovider.handlers.helpers.ResumptionTokenHelper;
import org.dspace.xoai.dataprovider.handlers.helpers.SetRepositoryHelper;
import org.dspace.xoai.dataprovider.handlers.results.ListSetsResult;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.dataprovider.repository.Repository;
import org.dspace.xoai.model.oaipmh.ListSets;
import org.dspace.xoai.model.oaipmh.ResumptionToken;

public class ListSetsHandler
extends VerbHandler<ListSets> {
    private final SetRepositoryHelper setRepositoryHelper = new SetRepositoryHelper(this.getRepository().getSetRepository());

    public ListSetsHandler(Context context, Repository repository) {
        super(context, repository);
    }

    @Override
    public ListSets handle(OAICompiledRequest parameters) throws OAIException, HandlerException {
        ListSets result = new ListSets();
        if (!this.getRepository().getSetRepository().supportSets()) {
            throw new DoesNotSupportSetsException();
        }
        int length = this.getRepository().getConfiguration().getMaxListSets();
        ListSetsResult listSetsResult = this.setRepositoryHelper.getSets(this.getContext(), this.getOffset(parameters), length);
        List<Set> sets = listSetsResult.getResults();
        if (sets.isEmpty() && parameters.getResumptionToken().isEmpty()) {
            throw new NoMatchesException();
        }
        if (sets.size() > length) {
            sets = sets.subList(0, length);
        }
        for (Set set : sets) {
            result.getSets().add(set.toOAIPMH());
        }
        ResumptionToken.Value currentResumptionToken = new ResumptionToken.Value();
        if (parameters.hasResumptionToken()) {
            currentResumptionToken = parameters.getResumptionToken();
        } else if (listSetsResult.hasMore()) {
            currentResumptionToken = parameters.extractResumptionToken();
        }
        ResumptionTokenHelper resumptionTokenHelper = new ResumptionTokenHelper(currentResumptionToken, this.getRepository().getConfiguration().getMaxListSets());
        result.withResumptionToken(resumptionTokenHelper.resolve(listSetsResult.hasMore()));
        return result;
    }

    private int getOffset(OAICompiledRequest parameters) {
        if (!parameters.hasResumptionToken()) {
            return 0;
        }
        if (parameters.getResumptionToken().getOffset() == null) {
            return 0;
        }
        return parameters.getResumptionToken().getOffset().intValue();
    }
}

