/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers.helpers;

import com.google.common.base.Predicates;
import org.dspace.xoai.model.oaipmh.ResumptionToken;

public class ResumptionTokenHelper {
    private ResumptionToken.Value current;
    private long maxPerPage;
    private Long totalResults;

    public ResumptionTokenHelper(ResumptionToken.Value current, long maxPerPage) {
        this.current = current;
        this.maxPerPage = maxPerPage;
    }

    public ResumptionTokenHelper withTotalResults(long totalResults) {
        this.totalResults = totalResults;
        return this;
    }

    public ResumptionToken resolve(boolean hasMoreResults) {
        if (this.isInitialOffset() && !hasMoreResults) {
            return null;
        }
        if (hasMoreResults) {
            ResumptionToken.Value next = this.current.next(this.maxPerPage);
            return this.populate(new ResumptionToken(next));
        }
        ResumptionToken resumptionToken = new ResumptionToken();
        resumptionToken.withCursor((long)Math.round((this.current.getOffset() + this.maxPerPage) / this.maxPerPage));
        if (this.totalResults != null) {
            resumptionToken.withCompleteListSize(this.totalResults.longValue());
        }
        return resumptionToken;
    }

    private boolean isInitialOffset() {
        return Predicates.isNull().apply((Object)this.current.getOffset()) || this.current.getOffset() == 0L;
    }

    private ResumptionToken populate(ResumptionToken resumptionToken) {
        if (this.totalResults != null) {
            resumptionToken.withCompleteListSize(this.totalResults.longValue());
        }
        resumptionToken.withCursor((long)Math.round(resumptionToken.getValue().getOffset() / this.maxPerPage));
        return resumptionToken;
    }
}

