/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers.helpers;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.xoai.dataprovider.handlers.results.ListSetsResult;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.dataprovider.repository.SetRepository;

public class SetRepositoryHelper {
    private static Logger log = LogManager.getLogger(SetRepositoryHelper.class);
    private SetRepository setRepository;

    public SetRepositoryHelper(SetRepository setRepository) {
        this.setRepository = setRepository;
    }

    public ListSetsResult getSets(Context context, int offset, int length) {
        ArrayList<Set> results = new ArrayList<Set>();
        List<Set> statics = context.getSets();
        if (offset < statics.size()) {
            log.debug((Object)"Offset less than static sets size");
            if (length + offset < statics.size()) {
                log.debug((Object)"Offset + length less than static sets size");
                for (int i = offset; i < offset + length; ++i) {
                    results.add(statics.get(i));
                }
                return new ListSetsResult(true, results);
            }
            log.debug((Object)"Offset + length greater or equal than static sets size");
            for (int i = offset; i < statics.size(); ++i) {
                results.add(statics.get(i));
            }
            int newLength = length - (statics.size() - offset);
            ListSetsResult res = this.setRepository.retrieveSets(0, newLength);
            results.addAll(res.getResults());
            if (!res.hasTotalResults()) {
                return new ListSetsResult(res.hasMore(), results);
            }
            return new ListSetsResult(res.hasMore(), results, res.getTotalResults() + statics.size());
        }
        log.debug((Object)"Offset greater or equal than static sets size");
        int newOffset = offset - statics.size();
        ListSetsResult res = this.setRepository.retrieveSets(newOffset, length);
        results.addAll(res.getResults());
        if (!res.hasTotalResults()) {
            return new ListSetsResult(res.hasMore(), results);
        }
        return new ListSetsResult(res.hasMore(), results, res.getTotalResults() + statics.size());
    }

    public boolean exists(Context context, String setSpec) {
        List<Set> statics = context.getSets();
        for (Set set : statics) {
            if (!set.getSpec().equals(set)) continue;
            return true;
        }
        return this.setRepository.exists(setSpec);
    }
}

