/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import org.dspace.xoai.dataprovider.exceptions.InternalOAIException;
import org.dspace.xoai.dataprovider.filter.FilterResolver;
import org.dspace.xoai.dataprovider.model.ItemIdentifier;
import org.dspace.xoai.dataprovider.model.MetadataFormat;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.dataprovider.model.conditions.Condition;

public class Context {
    private Transformer metadataTransformer;
    private List<MetadataFormat> metadataFormats = new ArrayList<MetadataFormat>();
    private List<Set> sets = new ArrayList<Set>();
    private Condition condition;

    public static Context context() {
        return new Context();
    }

    public List<Set> getSets() {
        return this.sets;
    }

    public Context withSet(Set set) {
        if (!set.hasCondition()) {
            throw new InternalOAIException("Context sets must have a condition");
        }
        this.sets.add(set);
        return this;
    }

    public Transformer getTransformer() {
        return this.metadataTransformer;
    }

    public Context withTransformer(Transformer metadataTransformer) {
        this.metadataTransformer = metadataTransformer;
        return this;
    }

    public List<MetadataFormat> getMetadataFormats() {
        return this.metadataFormats;
    }

    public Context withMetadataFormat(MetadataFormat metadataFormat) {
        int remove = -1;
        for (int i = 0; i < this.metadataFormats.size(); ++i) {
            if (!this.metadataFormats.get(i).getPrefix().equals(metadataFormat.getPrefix())) continue;
            remove = i;
        }
        if (remove >= 0) {
            this.metadataFormats.remove(remove);
        }
        this.metadataFormats.add(metadataFormat);
        return this;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Context withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public MetadataFormat formatForPrefix(String metadataPrefix) {
        for (MetadataFormat format : this.metadataFormats) {
            if (!format.getPrefix().equals(metadataPrefix)) continue;
            return format;
        }
        return null;
    }

    public boolean hasTransformer() {
        return this.metadataTransformer != null;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public boolean isStaticSet(String setSpec) {
        for (Set set : this.sets) {
            if (!set.getSpec().equals(setSpec)) continue;
            return true;
        }
        return false;
    }

    public Set getSet(String setSpec) {
        for (Set set : this.sets) {
            if (!set.getSpec().equals(setSpec)) continue;
            return set;
        }
        return null;
    }

    public boolean hasSet(String set) {
        return this.isStaticSet(set);
    }

    public Context withMetadataFormat(String prefix, Transformer transformer) {
        this.withMetadataFormat(new MetadataFormat().withNamespace(prefix).withPrefix(prefix).withSchemaLocation(prefix).withTransformer(transformer));
        return this;
    }

    public Context withMetadataFormat(String prefix, Transformer transformer, Condition condition) {
        this.withMetadataFormat(new MetadataFormat().withNamespace(prefix).withPrefix(prefix).withSchemaLocation(prefix).withTransformer(transformer).withCondition(condition));
        return this;
    }

    public Context withoutMetadataFormats() {
        this.metadataFormats.clear();
        return this;
    }

    public List<MetadataFormat> formatFor(FilterResolver resolver, ItemIdentifier item) {
        ArrayList<MetadataFormat> result = new ArrayList<MetadataFormat>();
        for (MetadataFormat format : this.metadataFormats) {
            if (format.hasCondition() && !format.getCondition().getFilter(resolver).isItemShown(item)) continue;
            result.add(format);
        }
        return result;
    }
}

