/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.core;

import com.lyncode.xoai.dataprovider.core.OAIParameters;
import com.lyncode.xoai.dataprovider.exceptions.BadArgumentException;
import java.util.Date;

public class ResumptionToken {
    private int _offset;
    private String _set;
    private Date _from;
    private Date _until;
    private String _metadataPrefix;
    private boolean empty;

    public ResumptionToken(int offset, String metadataPrefix, String set, Date from, Date until) {
        this.empty = false;
        this._set = set;
        this._offset = offset;
        this._from = from;
        this._until = until;
        this._metadataPrefix = metadataPrefix;
    }

    public ResumptionToken(int offset) {
        this.empty = false;
        this._set = null;
        this._from = null;
        this._until = null;
        this._metadataPrefix = null;
        this._offset = offset;
    }

    public ResumptionToken() {
        this.empty = true;
        this._offset = 0;
        this._set = null;
        this._from = null;
        this._until = null;
        this._metadataPrefix = null;
    }

    public ResumptionToken(int offset, OAIParameters parameters) throws BadArgumentException {
        this.empty = false;
        this._offset = offset;
        if (parameters.hasFrom()) {
            this._from = parameters.getFrom();
        }
        if (parameters.hasUntil()) {
            this._until = parameters.getUntil();
        }
        if (parameters.hasSet()) {
            this._set = parameters.getSet();
        }
        if (parameters.hasMetadataPrefix()) {
            this._metadataPrefix = parameters.getMetadataPrefix();
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean hasFrom() {
        return this._from != null;
    }

    public boolean hasUntil() {
        return this._until != null;
    }

    public boolean hasSet() {
        return this._set != null;
    }

    public boolean hasMetadataPrefix() {
        return this._metadataPrefix != null;
    }

    public String getMetadataPrefix() {
        return this._metadataPrefix;
    }

    public Date getFrom() {
        return this._from;
    }

    public String getSet() {
        return this._set;
    }

    public Date getUntil() {
        return this._until;
    }

    public int getOffset() {
        return this._offset;
    }
}

