/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.data.internal;

import com.lyncode.xoai.dataprovider.core.ListItemIdentifiersResult;
import com.lyncode.xoai.dataprovider.core.ListItemsResults;
import com.lyncode.xoai.dataprovider.core.XOAIContext;
import com.lyncode.xoai.dataprovider.data.Item;
import com.lyncode.xoai.dataprovider.data.internal.MetadataFormat;
import com.lyncode.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import com.lyncode.xoai.dataprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.dataprovider.exceptions.OAIException;
import com.lyncode.xoai.dataprovider.filter.Scope;
import com.lyncode.xoai.dataprovider.filter.ScopedFilter;
import com.lyncode.xoai.dataprovider.services.api.ItemRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ItemRepositoryHelper {
    private ItemRepository itemRepository;

    public ItemRepositoryHelper(ItemRepository itemRepository) {
        this.itemRepository = itemRepository;
    }

    public ListItemIdentifiersResult getItemIdentifiers(XOAIContext context, int offset, int length, String metadataPrefix) throws CannotDisseminateFormatException, OAIException {
        return this.itemRepository.getItemIdentifiers(this.getScopedFilters(context, metadataPrefix), offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiers(XOAIContext context, int offset, int length, String metadataPrefix, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItemIdentifiers(filters, offset, length, from);
    }

    private List<ScopedFilter> getScopedFilters(XOAIContext context, String metadataPrefix) throws CannotDisseminateFormatException {
        MetadataFormat metadataFormat;
        ArrayList<ScopedFilter> filters = new ArrayList<ScopedFilter>();
        if (context.hasCondition()) {
            filters.add(new ScopedFilter(context.getCondition(), Scope.Context));
        }
        if ((metadataFormat = context.getFormatByPrefix(metadataPrefix)).hasCondition()) {
            filters.add(new ScopedFilter(metadataFormat.getCondition(), Scope.MetadataFormat));
        }
        return filters;
    }

    public ListItemIdentifiersResult getItemIdentifiersUntil(XOAIContext context, int offset, int length, String metadataPrefix, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItemIdentifiersUntil(filters, offset, length, until);
    }

    public ListItemIdentifiersResult getItemIdentifiers(XOAIContext context, int offset, int length, String metadataPrefix, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        return this.itemRepository.getItemIdentifiers(this.getScopedFilters(context, metadataPrefix), offset, length, from, until);
    }

    public ListItemIdentifiersResult getItemIdentifiers(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItemIdentifiers(filters, offset, length);
        }
        return this.itemRepository.getItemIdentifiers(filters, offset, length, setSpec);
    }

    public ListItemIdentifiersResult getItemIdentifiers(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItemIdentifiers(filters, offset, length, from);
        }
        return this.itemRepository.getItemIdentifiers(filters, offset, length, setSpec, from);
    }

    public ListItemIdentifiersResult getItemIdentifiersUntil(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItemIdentifiersUntil(filters, offset, length, until);
        }
        return this.itemRepository.getItemIdentifiersUntil(filters, offset, length, setSpec, until);
    }

    public ListItemIdentifiersResult getItemIdentifiers(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItemIdentifiers(filters, offset, length, from, until);
        }
        return this.itemRepository.getItemIdentifiers(filters, offset, length, setSpec, from, until);
    }

    public ListItemsResults getItems(XOAIContext context, int offset, int length, String metadataPrefix) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItems(filters, offset, length);
    }

    public ListItemsResults getItems(XOAIContext context, int offset, int length, String metadataPrefix, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItems(filters, offset, length, from);
    }

    public ListItemsResults getItemsUntil(XOAIContext context, int offset, int length, String metadataPrefix, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItemsUntil(filters, offset, length, until);
    }

    public ListItemsResults getItems(XOAIContext context, int offset, int length, String metadataPrefix, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItems(filters, offset, length, from, until);
    }

    public ListItemsResults getItems(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItems(filters, offset, length);
        }
        return this.itemRepository.getItems(filters, offset, length, setSpec);
    }

    public ListItemsResults getItems(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItems(filters, offset, length, from);
        }
        return this.itemRepository.getItems(filters, offset, length, setSpec, from);
    }

    public ListItemsResults getItemsUntil(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItemsUntil(filters, offset, length, until);
        }
        return this.itemRepository.getItemsUntil(filters, offset, length, setSpec, until);
    }

    public ListItemsResults getItems(XOAIContext context, int offset, int length, String metadataPrefix, String setSpec, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            if (context.getSetFilter(setSpec) != null) {
                filters.add(new ScopedFilter(context.getSetFilter(setSpec), Scope.Set));
            }
            return this.itemRepository.getItems(filters, offset, length, from, until);
        }
        return this.itemRepository.getItems(filters, offset, length, setSpec, from, until);
    }

    public Item getItem(String identifier) throws IdDoesNotExistException, OAIException {
        return this.itemRepository.getItem(identifier);
    }
}

