/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.sets;

import com.lyncode.xoai.dataprovider.core.Set;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.filter.FilterManager;
import com.lyncode.xoai.dataprovider.sets.StaticSet;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.SetConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticSetManager {
    private Map<String, StaticSet> sets = new HashMap<String, StaticSet>();

    public StaticSetManager(List<SetConfiguration> setConfigurations, FilterManager filterManager) throws ConfigurationException {
        for (SetConfiguration configuredSet : setConfigurations) {
            StaticSet set = null;
            set = configuredSet.hasFilter() ? new StaticSet(filterManager.getFilter(configuredSet.getFilter().getReference()), configuredSet.getSpec(), configuredSet.getName()) : new StaticSet(configuredSet.getSpec(), configuredSet.getName());
            this.sets.put(configuredSet.getId(), set);
        }
    }

    public boolean setExists(String id) {
        return this.sets.containsKey(id);
    }

    public StaticSet getSet(String id) {
        return this.sets.get(id);
    }

    public List<Set> getSets() {
        return new ArrayList<Set>(this.sets.values());
    }
}

