/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.read;

import com.lyncode.xoai.dataprovider.xml.read.XmlReaderException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLInputFactory2;

public class XmlReader {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory2.newFactory();
    private final XMLEventReader xmlEventParser;

    public XmlReader(InputStream stream) throws XMLStreamException {
        this.xmlEventParser = XML_INPUT_FACTORY.createXMLEventReader(stream);
    }

    public boolean isStart() throws XmlReaderException {
        return this.getPeek().isStartElement();
    }

    public void proceedToTheNextStartElement() throws XmlReaderException {
        try {
            this.xmlEventParser.nextEvent();
            while (!this.getPeek().isStartElement()) {
                this.xmlEventParser.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public boolean isEnd() throws XmlReaderException {
        return this.getPeek().isEndElement();
    }

    public String getAttribute(String name) throws XmlReaderException {
        Iterator<Attribute> attributes = this.getPeek().asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute next = attributes.next();
            if (!next.getName().getLocalPart().toLowerCase().equals(name.toLowerCase())) continue;
            return next.getValue();
        }
        return null;
    }

    public boolean isText() throws XmlReaderException {
        return this.getPeek().isCharacters();
    }

    public String getText() throws XmlReaderException {
        if (!this.isText()) {
            try {
                this.xmlEventParser.nextEvent();
                String data = this.getPeek().asCharacters().getData();
                this.proceedToNextElement();
                return data;
            }
            catch (XMLStreamException e) {
                throw new XmlReaderException(e);
            }
        }
        return null;
    }

    public String getNextElementText(String elementName) throws XmlReaderException {
        this.proceedToNextElement();
        if (!this.isStart()) {
            throw new XmlReaderException("Expecting a start element '" + elementName + "'");
        }
        String text = this.getText();
        if (!this.isEnd()) {
            throw new XmlReaderException("Expecting a end element '" + elementName + "'");
        }
        return text;
    }

    public void proceedToNextElement() throws XmlReaderException {
        try {
            this.xmlEventParser.nextEvent();
            while (!this.isStart() && !this.isEnd()) {
                this.xmlEventParser.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public boolean elementNameIs(String name) throws XmlReaderException {
        return this.getPeek().asStartElement().getName().getLocalPart().toLowerCase().equals(name.toLowerCase());
    }

    public XMLEvent getPeek() throws XmlReaderException {
        try {
            return this.xmlEventParser.peek();
        }
        catch (XMLStreamException e) {
            throw new XmlReaderException(e);
        }
    }

    public String getName() throws XmlReaderException {
        if (this.getPeek().isStartElement()) {
            return this.getPeek().asStartElement().getName().getLocalPart();
        }
        if (this.getPeek().isEndDocument()) {
            return this.getPeek().asEndElement().getName().getLocalPart();
        }
        return null;
    }
}

