/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters;

import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterValue;
import javax.xml.stream.XMLStreamException;

public abstract class SimpleType<T>
extends ParameterValue<T> {
    private T value;

    public T getValue() {
        return this.value;
    }

    public SimpleType withValue(T value) {
        this.value = value;
        return this;
    }

    public boolean is(Class<?> clazz) {
        return this.getClass().isAssignableFrom(clazz);
    }

    @Override
    public void write(XmlOutputContext writer) throws WritingXmlException {
        try {
            writer.getWriter().writeStartElement(this.getXmlName());
            if (this.hasName()) {
                writer.getWriter().writeAttribute("name", this.getName());
            }
            writer.getWriter().writeCharacters(String.valueOf(this.value));
            writer.getWriter().writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }

    public int asInteger() {
        return (Integer)this.getValue();
    }

    public String asString() {
        return (String)this.getValue();
    }

    public Double asDouble() {
        return (Double)this.getValue();
    }

    public Float asFloat() {
        return (Float)this.getValue();
    }

    public Boolean asBoolean() {
        return (Boolean)this.getValue();
    }

    protected abstract String getXmlName();
}

