/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters;

import com.lyncode.xoai.dataprovider.xml.read.XmlReader;
import com.lyncode.xoai.dataprovider.xml.read.XmlReaderException;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterList;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.ParseException;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.Parser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.BooleanValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.DoubleValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.FloatValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.IntValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.ParameterMapParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.StringValueParser;

public class ParameterListParser
extends Parser<ParameterList> {
    private FloatValueParser floatValueParser;
    private StringValueParser stringValueParser;
    private IntValueParser intValueParser;
    private DoubleValueParser doubleValueParser;
    private BooleanValueParser booleanValueParser;
    private ParameterMapParser parameterMapParser;

    public void load(FloatValueParser floatValueParser, BooleanValueParser booleanValueParser, StringValueParser stringValueParser, DoubleValueParser doubleValueParser, IntValueParser intValueParser, ParameterMapParser parameterMapParser) {
        this.floatValueParser = floatValueParser;
        this.booleanValueParser = booleanValueParser;
        this.stringValueParser = stringValueParser;
        this.doubleValueParser = doubleValueParser;
        this.intValueParser = intValueParser;
        this.parameterMapParser = parameterMapParser;
    }

    @Override
    public ParameterList parse(XmlReader reader) throws ParseException {
        try {
            String name = reader.getAttribute("name");
            ParameterList parameterList = (ParameterList)new ParameterList().withName(name);
            reader.proceedToNextElement();
            while (reader.isStart()) {
                if (reader.elementNameIs("list")) {
                    parameterList.withValues(this.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("int")) {
                    parameterList.withValues(this.intValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("double")) {
                    parameterList.withValues(this.doubleValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("float")) {
                    parameterList.withValues(this.floatValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("boolean")) {
                    parameterList.withValues(this.booleanValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("string")) {
                    parameterList.withValues(this.stringValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("map")) {
                    parameterList.withValues(this.parameterMapParser.parse(reader));
                    continue;
                }
                throw new ParseException("Unknown configuration value " + reader.getName());
            }
            reader.proceedToNextElement();
            return parameterList;
        }
        catch (XmlReaderException e) {
            throw new ParseException(e);
        }
    }
}

