/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters;

import com.lyncode.xoai.dataprovider.xml.read.XmlReader;
import com.lyncode.xoai.dataprovider.xml.read.XmlReaderException;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterMap;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.ParseException;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.Parser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.BooleanValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.DoubleValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.FloatValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.IntValueParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.ParameterListParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.parameters.StringValueParser;

public class ParameterMapParser
extends Parser<ParameterMap> {
    private FloatValueParser floatValueParser;
    private StringValueParser stringValueParser;
    private ParameterListParser parameterListParser;
    private IntValueParser intValueParser;
    private DoubleValueParser doubleValueParser;
    private BooleanValueParser booleanValueParser;

    public void load(FloatValueParser floatValueParser, BooleanValueParser booleanValueParser, StringValueParser stringValueParser, ParameterListParser parameterListParser, DoubleValueParser doubleValueParser, IntValueParser intValueParser) {
        this.floatValueParser = floatValueParser;
        this.booleanValueParser = booleanValueParser;
        this.stringValueParser = stringValueParser;
        this.parameterListParser = parameterListParser;
        this.doubleValueParser = doubleValueParser;
        this.intValueParser = intValueParser;
    }

    @Override
    public ParameterMap parse(XmlReader reader) throws ParseException {
        try {
            ParameterMap parameterMap = new ParameterMap();
            parameterMap.withName(reader.getAttribute("name"));
            reader.proceedToNextElement();
            while (reader.isStart()) {
                if (reader.elementNameIs("list")) {
                    parameterMap.withValues(this.parameterListParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("int")) {
                    parameterMap.withValues(this.intValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("double")) {
                    parameterMap.withValues(this.doubleValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("float")) {
                    parameterMap.withValues(this.floatValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("boolean")) {
                    parameterMap.withValues(this.booleanValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("string")) {
                    parameterMap.withValues(this.stringValueParser.parse(reader));
                    continue;
                }
                if (reader.elementNameIs("map")) {
                    parameterMap.withValues(this.parse(reader));
                    continue;
                }
                throw new ParseException("Unknown configuration value " + reader.getName());
            }
            reader.proceedToNextElement();
            return parameterMap;
        }
        catch (XmlReaderException e) {
            throw new ParseException(e);
        }
    }
}

