/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.oaipmh;

import com.lyncode.xoai.serviceprovider.OAIServiceConfiguration;
import com.lyncode.xoai.serviceprovider.exceptions.ParseException;
import com.lyncode.xoai.serviceprovider.oaipmh.ElementParser;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.OAIPMHerrorType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.OAIPMHerrorcodeType;
import com.lyncode.xoai.serviceprovider.parser.AboutItemParser;
import com.lyncode.xoai.serviceprovider.parser.AboutSetParser;
import com.lyncode.xoai.serviceprovider.parser.DescriptionParser;
import com.lyncode.xoai.serviceprovider.parser.MetadataParser;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;

public class ErrorParser
extends ElementParser<OAIPMHerrorType> {
    public static final String NAME = "error";
    public static final String CODE = "code";

    public ErrorParser(OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> oaiServiceConfiguration) {
        super(oaiServiceConfiguration);
    }

    @Override
    public OAIPMHerrorType parseElement(XMLEventReader reader) throws ParseException {
        OAIPMHerrorType error = new OAIPMHerrorType();
        try {
            if (!reader.peek().asStartElement().getName().getLocalPart().equals(NAME)) {
                throw new ParseException("Expecting error element");
            }
            Iterator<Attribute> attrs = reader.peek().asStartElement().getAttributes();
            while (attrs.hasNext()) {
                Attribute attr = attrs.next();
                if (!attr.getName().getLocalPart().equals(CODE)) continue;
                error.setCode(OAIPMHerrorcodeType.fromValue(attr.getValue()));
            }
            reader.nextEvent();
            if (reader.peek().isCharacters()) {
                error.setValue(reader.peek().asCharacters().getData());
                reader.nextEvent();
                this.nextElement(reader);
            }
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
        return error;
    }
}

