/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.verbs;

import com.lyncode.xoai.serviceprovider.OAIServiceConfiguration;
import com.lyncode.xoai.serviceprovider.core.Parameters;
import com.lyncode.xoai.serviceprovider.exceptions.BadArgumentException;
import com.lyncode.xoai.serviceprovider.exceptions.InternalHarvestException;
import com.lyncode.xoai.serviceprovider.exceptions.ParseException;
import com.lyncode.xoai.serviceprovider.oaipmh.OAIPMHParser;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.IdentifyType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.OAIPMHtype;
import com.lyncode.xoai.serviceprovider.parser.AboutItemParser;
import com.lyncode.xoai.serviceprovider.parser.AboutSetParser;
import com.lyncode.xoai.serviceprovider.parser.DescriptionParser;
import com.lyncode.xoai.serviceprovider.parser.MetadataParser;
import com.lyncode.xoai.serviceprovider.verbs.AbstractVerb;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class Identify
extends AbstractVerb {
    public Identify(Parameters baseUrl, OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> config) throws InternalHarvestException, BadArgumentException {
        super(baseUrl, config);
    }

    private String makeUrl() {
        return this.getParameters().toUrl();
    }

    public IdentifyType harvest() throws InternalHarvestException, BadArgumentException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        String url = this.makeUrl();
        this.getServiceProvider().getLogger().info((Object)("Harvesting: " + url));
        HttpGet httpget = new HttpGet(url);
        httpget.addHeader("User-Agent", this.getServiceProvider().getServiceName() + " : XOAI Service Provider");
        httpget.addHeader("From", this.getServiceProvider().getServiceName());
        HttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            StatusLine status = response.getStatusLine();
            this.getServiceProvider().getLogger().debug((Object)response.getStatusLine());
            if (status.getStatusCode() == 503) {
                Header[] headers;
                for (Header h : headers = response.getAllHeaders()) {
                    if (!h.getName().equals("Retry-After")) continue;
                    String retry_time = h.getValue();
                    try {
                        Thread.sleep(Integer.parseInt(retry_time) * 1000);
                    }
                    catch (NumberFormatException e) {
                        this.getServiceProvider().getLogger().warn((Object)("Cannot parse " + retry_time + " to Integer"), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        this.getServiceProvider().getLogger().debug((Object)e.getMessage(), (Throwable)e);
                    }
                    httpclient.getConnectionManager().shutdown();
                    httpclient = new DefaultHttpClient();
                    response = httpclient.execute((HttpUriRequest)httpget);
                }
            }
            HttpEntity entity = response.getEntity();
            InputStream instream = entity.getContent();
            OAIPMHtype pmh = OAIPMHParser.parse(instream, this.getServiceProvider());
            return pmh.getIdentify();
        }
        catch (IOException e) {
            throw new InternalHarvestException(e);
        }
        catch (ParseException e) {
            throw new InternalHarvestException(e);
        }
    }
}

