package dulab.adap.common.algorithms;

import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */
public class Combinations<Type>
{
    private final List<List<Type>> lists;

    public Combinations(@Nonnull List<List<Type>> lists) {
        this.lists = lists;
    }

    /**
     * Wrapper for generateCombinations
     *
     * @return combinations of Peaks from multiple Peak lists
     */

    @Nonnull
    public List<List<Type>> get()
    {
        List<List<Type>> combinations = new ArrayList<>();
        generateCombinations(combinations, 0, new ArrayList<Type>(lists.size()));
        return combinations;
    }

    /**
     * Generate all possible combinations of Peaks from multiple Peak lists
     *
     * @param combinations combinations of Peaks
     * @param position current position where a peak is added
     * @param combination current combination
     */

    private void generateCombinations(List<List<Type>> combinations, int position, List<Type> combination)
    {
        if (position >= lists.size()) {
            combinations.add(combination);
            return;
        }

        for (Type peak : lists.get(position)) {
            List<Type> newCombination = new ArrayList<>(combination);
            newCombination.add(peak);
            generateCombinations(combinations, position + 1, newCombination);
        }
    }
}
