/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.common.algorithms;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author aleksandrsmirnov
 */
public class Combinatorics {
    
    /**
     * Finds all combinations of k numbers such that their sum equals n
     * @param n maximum number to choose from
     * @param k size of the tuples
     * @return list of tuples
     * Example for n = 3, k = 2: [3,0], [2, 1], [1, 2], [0, 3]
     */
    
    public static List <int[]> getCombinations(final int n, final int k) 
    {
        List <int[]> result = new ArrayList <> ();
        
        //List <Integer> tuple = new ArrayList(Collections.nCopies(k, 0))
        int[] tuple = new int[k];
        tuple[0] = n;
        
        int k1 = 0, k2 = 1;
        
        // Iterate until the tuple becomes [0,...,0,n]
        while (tuple[k-1] < n)
        {
            result.add(tuple.clone());
            
            if (k1 == k - 1) // If the end of the tuple is reached
                do {
                    tuple[k1] = 0;
                    --k1;
                } while (tuple[k1] == 0);
            
            // decrease the current value and increase the next value
            --tuple[k1];
            k2 = k1 + 1;
            tuple[k2] = n;
            for (int i = 0; i <= k1; ++i) tuple[k2] -= tuple[i];
            k1 = k2;
        }
        
        result.add(tuple.clone());
        
        return result;
    }
    
}
