/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.common.algorithms;

/**
 *
 * @author aleksandrsmirnov
 */
public class SymmetricMatrix {
    double[][] data;
    int size;
    
    // ------------------------------------------------------------------------
    // ----- Constructors -----------------------------------------------------
    // ------------------------------------------------------------------------
    
    public SymmetricMatrix(final int size) {
        data = new double[size][size];
        this.size = size;
    }
    
    public SymmetricMatrix(final SymmetricMatrix matrix) {
        size = matrix.size;
        data = new double[size][size];
        for (int i = 0; i < size; ++i)
            data[i] = matrix.data[i].clone();
    }
    
    // ------------------------------------------------------------------------
    // ----- Methods ----------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public ArgMin argmin() {
        double min = Double.MAX_VALUE;
        int index1 = 0;
        int index2 = 0;
        
        for (int i = 0; i < size; ++i)
            for (int j = i; j < size; ++j)
                if (data[i][j] < min) {
                    min = data[i][j];
                    index1 = i;
                    index2 = j;
                }
        
        return new ArgMin(min,
                java.lang.Math.min(index1, index2),
                java.lang.Math.max(index1, index2));
    }
    
    public void set(final int i, final int j, final double v) {
        if (i < j) 
            data[i][j] = v;
        else
            data[j][i] = v;
    }
    
    public double get(final int i, final int j) {
        if (i < j) return data[i][j];
        return data[j][i];
    }
    
    public int size() {return size;}
}
