package dulab.adap.common.algorithms.machineleanring;

import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;

import javax.annotation.Nonnull;

/**
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */
public class ConstrainedDBSCANClustererV2<T extends Clusterable> extends DBSCANClusterer<T>
{
    public interface DistanceMeasure {
        double compute(Clusterable a, Clusterable b);
    }

    private final DistanceMeasure measure;

    public ConstrainedDBSCANClustererV2(final double eps, final int minPts, @Nonnull DistanceMeasure measure) {
        super(eps, minPts);
        this.measure = measure;
    }

    @Override @Nonnull
    protected double distance(@Nonnull final Clusterable p1, @Nonnull final Clusterable p2) {
        return measure.compute(p1, p2);
    }
}
