/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package dulab.adap.common.algorithms.machineleanring;

/**
 *
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */


public class MarkovGraphClusteringParameters 
{
    public double inflationCoefficient = 2.0;
    public int maxIteration = 20;
    public double tolerance = 1e-6;
    
    public MarkovGraphClusteringParameters inflationCoefficient(double value) 
    {
        if (value > 1.0) 
            this.inflationCoefficient = value;
        else
            throw new IllegalArgumentException("Cannot assign value " + 
                    Double.toString(value) + " to inflationCoefficient. " + 
                    "The value should be greater then 1.0");
        
        return this;
    }
    
    public MarkovGraphClusteringParameters maxIteration(int value)
    {
        if (value > 0)
            this.maxIteration = value;
        else
            throw new IllegalArgumentException("Cannot assign value " + 
                    Integer.toString(value) + " to maxIteration. " + 
                    "The value should be positive");
        
        return this;
    }
    
    public MarkovGraphClusteringParameters tolerance(double value)
    {
        if (value > 0.0)
            this.tolerance = value;
        else
            throw new IllegalArgumentException("Cannot assign value " + 
                    Double.toString(value) + " to tolerance. " + 
                    "The value should be positive");
        
        return this;
    }
}
