package dulab.adap.common.algorithms.optimization;

import org.jblas.DoubleMatrix;
import org.jblas.Solve;

import javax.annotation.Nonnull;

/**
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */
public class LeastSquaresOptimization
{
    public static class Result
    {
        public double[][] coefficients;
        public double[] errors;
        public double averageError;
    }

    @Nonnull
    public static Result execute(@Nonnull final double[][] matrixA,
                                 @Nonnull final double[][] matrixB)
            throws IllegalArgumentException
    {
        if (matrixA.length != matrixB.length)
            throw new IllegalArgumentException("Number of rows of A and B is not the same");

        DoubleMatrix a = new DoubleMatrix(matrixA);
        DoubleMatrix b = new DoubleMatrix(matrixB);

        DoubleMatrix at = a.transpose();
        DoubleMatrix a2 = at.mmul(a);

        DoubleMatrix x = Solve.solve(a2, at.mmul(b));

        DoubleMatrix r = a.mmul(x).sub(b).divRowVector(b.columnMaxs());
        DoubleMatrix errors = r.mul(r).columnMeans();

        Result result = new Result();
        result.coefficients = x.transpose().toArray2();
        result.errors = errors.toArray();
        result.averageError = errors.mean();

        return result;
    }
}
