/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.common.distances;

import dulab.adap.common.types.SparseVector;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.NoSuchElementException;

/**
 *
 * @author aleksandrsmirnov
 */
public class DotProductDistance extends Distance implements Serializable
{
    private static final double SCALE = 2 / java.lang.Math.PI;
    private static final double TOLERANCE = 1e-3;
    
    /*
    @Override
    public final double call(SparseVector v1, SparseVector v2)
    {
        double sum = 0.0;
        
        for (Entry <Double, Double> entry : v1.data().entrySet())
            sum += entry.getValue() * v2.get(entry.getKey());
        
        sum /= v1.norm() * v2.norm(); // Normalize
        
        if (sum > 1.0) sum = 1.0; // If sum > 1 then Math.acos(sum) gives NaN
        
        return SCALE * java.lang.Math.acos(sum);
    }*/
    
    @Override
    public final double call(SparseVector v1, SparseVector v2) {
        return call(v1, v2, TOLERANCE);
    }
    
    @Override
    public final double call(SparseVector v1, SparseVector v2, double tolerance)
    {
        if (v1.size() == 0 || v2.size() == 0) return 1.0;
        
        double sum = 0.0;
        
        Iterator <Entry <Double, Double>> it1 = v1.data().entrySet().iterator();
        Iterator <Entry <Double, Double>> it2 = v2.data().entrySet().iterator();
        
        Entry <Double, Double> e1 = it1.next();
        Entry <Double, Double> e2 = it2.next();
        
        for (;;)
        {
            double delta = e1.getKey() - e2.getKey();

            try {
                if (delta < -tolerance) // x1 < x2 - tolerance
                    e1 = it1.next();
                else if (delta > tolerance) // x2 < x1 - tolerance
                    e2 = it2.next();
                else { // |x1 - x2| <= tolerance
                    sum += e1.getValue() * e2.getValue();
                    e1 = it1.next();
                    e2 = it2.next();
                }
            } catch (NoSuchElementException e) {break;}
        }
        
        sum /= v1.norm() * v2.norm(); // Normalize
        
        if (sum > 1.0) sum = 1.0; // If sum > 1 then Math.acos(sum) gives NaN
        
        return SCALE * java.lang.Math.acos(sum);
    }
}
