/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.common.parsers;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 *
 * @author aleksandrsmirnov
 */
public abstract class Parser
{
    public static final String JCAMP_FILE_FORMAT = "JCAMP File Format";
    public static final String MSP_FILE_FORMAT = "MSP File Format";
    
    public static final String[] ALL_FILE_FORMATS = {
        JCAMP_FILE_FORMAT, MSP_FILE_FORMAT
    };
    
    // ------------------------------------------------------------------------
    // ----- Properties -------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public abstract List <CompoundInfo> info();
    
    public abstract List <Map <Double, Double>> data();
    
    // ------------------------------------------------------------------------
    // ----- Methods ----------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public static Parser loadInstance(String fileFormat, String fileName) 
            throws IOException
    {
        Parser result = null;
        
        switch (fileFormat) {
            case JCAMP_FILE_FORMAT:
                result = new JCAMPParser(fileName);
                break;
                
            case MSP_FILE_FORMAT:
                result = new MSPParser(fileName);
                break;
        }
        
        if (result == null)
            throw new IllegalArgumentException("File format is not recognized");
        
        return result;
    }
}
