/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.common.types;

import java.io.Serializable;

/**
 *
 * @author aleksandrsmirnov
 */
public class BallNode implements Serializable
{
    private double radius; // distance from the center to the farthest vector
    
    //final private SparseVector center; // Usually, the average of vectors
    final private int id;
    
    //List <Integer> indices;
    
    public BallNode parent, left, right;
    
    // ------------------------------------------------------------------------
    // ----- Constructors -----------------------------------------------------
    // ------------------------------------------------------------------------
    
    public BallNode(final int id, 
            //final List <Integer> indices,
            final BallNode parent)
    {
        this.id = id;
        //this.indices = indices;
        //this.vectors = vectors;
        this.radius = 0.0;
        
        this.parent = parent;
        this.left = null;
        this.right = null;
    }
    
    // ------------------------------------------------------------------------
    // ----- Methods ----------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public void setRadius(final double r) {this.radius = r;}
    
    // ------------------------------------------------------------------------
    // ----- Properties -------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public double getRadius() {return this.radius;}
    
    public int getID() {return this.id;}
    
    //public List <Integer> getIndices() {return this.indices;}
    
    //public int size() {return this.indices.size();}
    
    @Override
    public String toString() 
    {
        String result = Integer.toString(this.id);
        if (this.left != null || this.right != null) {
            result += " -> ";
            
            if (this.left != null)
                result += Integer.toString(this.left.id) + ",";
            
            if (this.right != null)
                result += Integer.toString(this.right.id);
        }
        
        return result;
    }
}
