package dulab.adap.common.types;

import javax.annotation.Nonnull;
import java.util.Arrays;

/**
 * This class is designed to store pairs (x,y)
 *
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */
public class Function
{
    /** x-values of each pair */
    public final double[] xs;

    /** y-values of each pair */
    public final double[] ys;

    /** Number of pairs */
    public final int length;

    /**
     * Creates an instance of the class. Two arrays are required to have the same size.
     * @param xs x-values
     * @param ys y-values
     */
    public Function(@Nonnull double[] xs, @Nonnull double[] ys) {
        length = xs.length;

        if (length != ys.length)
            throw new IncorrectLengthException();

        if (length == 0)
            throw new ZeroLengthException();

        this.xs = xs;
        this.ys = ys;
    }

    /**
     * Multiplies each y-value by the given factor
     * @param factor any number
     */
    public void scale(double factor) {
        for (int i = 0; i < length; ++i)
            ys[i] *= factor;
    }

    /**
     * Exception that is raised when arrays of two different sizes are passed to the constructor
     */
    public static class IncorrectLengthException extends IllegalArgumentException {
        public IncorrectLengthException() {
            super("Length of the arrays doesn't match");
        }
    }

    /**
     * Exception that is raised when an array of zero length is passed to the constructor
     */
    public static class ZeroLengthException extends IllegalArgumentException {
        public ZeroLengthException() {
            super("Arrays have zero length");
        }
    }
}
