/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.common.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author aleksandrsmirnov
 */
public class SparseMatrix implements Serializable
{
    final private List <SparseVector> data;
    private int columnCount;
    
    // ------------------------------------------------------------------------
    // ----- Constructors -----------------------------------------------------
    // ------------------------------------------------------------------------
    
    public SparseMatrix() {
        this.data = new ArrayList <> ();
        this.columnCount = 0;
    }
    
    public SparseMatrix(int size) {
        this.data = new ArrayList <> (size);
        this.columnCount = 0;
    }
    
    public SparseMatrix(final List <SparseVector> data) 
    {
        //this.data = new ArrayList <> (data);
        this.data = data;
        
        columnCount = 0;
        for (final SparseVector v : data) {
            int size = v.size();
            if (size > columnCount) columnCount = size;
        }
    }
    
    // ------------------------------------------------------------------------
    // ----- Methods ----------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public void add(final SparseVector v) 
    {
        //this.data.add(new SparseVector(v));
        this.data.add(v);
        
        int size = v.size();
        if (size > columnCount) columnCount = size;
    }
    
    public SparseVector mean()
    {
        SparseVector result = new SparseVector(this.columnCount);
        
        for (final SparseVector v : this.data)
            result.add(v, false);
        
        result.multiply(1f / this.data.size(), false);
        
        return result;
    }
    
    // ------------------------------------------------------------------------
    // ----- Properties -------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public int ncols() {return this.columnCount;}
    
    public int nrows() {return data.size();}
    
    public SparseVector get(int index) {return this.data.get(index);}
    
    public double get(int i, int j) {return this.data.get(i).get(j);}
    
    public List <SparseVector> rows() {return this.data;}
}
